/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mail.reader.service.impl;

import com.liferay.mail.reader.model.Account;
import com.liferay.mail.reader.service.base.AccountLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Date;
import java.util.List;

public class AccountLocalServiceImpl
extends AccountLocalServiceBaseImpl {
    public Account addAccount(long userId, String address, String personalName, String protocol, String incomingHostName, int incomingPort, boolean incomingSecure, String outgoingHostName, int outgoingPort, boolean outgoingSecure, String login, String password, boolean savePassword, String signature, boolean useSignature, String folderPrefix, long inboxFolderId, long draftFolderId, long sentFolderId, long trashFolderId, boolean defaultSender) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        Date now = new Date();
        long accountId = this.counterLocalService.increment();
        Account account = this.accountPersistence.create(accountId);
        account.setCompanyId(user.getCompanyId());
        account.setUserId(user.getUserId());
        account.setUserName(user.getFullName());
        account.setCreateDate(now);
        account.setModifiedDate(now);
        account.setAddress(address);
        account.setPersonalName(personalName);
        account.setProtocol(protocol);
        account.setIncomingHostName(incomingHostName);
        account.setIncomingPort(incomingPort);
        account.setIncomingSecure(incomingSecure);
        account.setOutgoingHostName(outgoingHostName);
        account.setOutgoingPort(outgoingPort);
        account.setOutgoingSecure(outgoingSecure);
        account.setLogin(login);
        if (savePassword && Validator.isNotNull((String)password)) {
            account.setPasswordDecrypted(password);
        } else {
            account.setPasswordDecrypted("");
        }
        account.setSavePassword(savePassword);
        account.setSignature(signature);
        account.setUseSignature(useSignature);
        account.setFolderPrefix(folderPrefix);
        account.setInboxFolderId(inboxFolderId);
        account.setDraftFolderId(draftFolderId);
        account.setSentFolderId(sentFolderId);
        account.setTrashFolderId(trashFolderId);
        account.setDefaultSender(defaultSender);
        this.accountPersistence.update((BaseModel)account);
        return account;
    }

    @Override
    public Account deleteAccount(Account account) throws PortalException {
        this.accountPersistence.remove((BaseModel)account);
        this.folderLocalService.deleteFolders(account.getAccountId());
        Indexer indexer = IndexerRegistryUtil.getIndexer(Account.class);
        indexer.delete((Object)account);
        return account;
    }

    @Override
    public Account deleteAccount(long accountId) throws PortalException {
        Account account = this.accountPersistence.findByPrimaryKey(accountId);
        return this.deleteAccount(account);
    }

    public void deleteAccounts(long userId) throws PortalException {
        List accounts = this.accountPersistence.findByUserId(userId);
        for (Account account : accounts) {
            this.deleteAccount(account);
        }
    }

    public Account getAccount(long userId, String address) throws PortalException {
        return this.accountPersistence.findByU_A(userId, address);
    }

    public List<Account> getAccounts(long userId) {
        return this.accountPersistence.findByUserId(userId);
    }

    public Account updateAccount(long accountId, String personalName, String password, boolean savePassword, String signature, boolean useSignature, String folderPrefix, boolean defaultSender) throws PortalException {
        Account account = this.accountPersistence.findByPrimaryKey(accountId);
        account.setModifiedDate(new Date());
        account.setPersonalName(personalName);
        if (savePassword && Validator.isNotNull((String)password)) {
            account.setPasswordDecrypted(password);
        } else {
            account.setPassword("");
        }
        account.setSavePassword(savePassword);
        account.setSignature(signature);
        account.setUseSignature(useSignature);
        account.setFolderPrefix(folderPrefix);
        account.setDefaultSender(defaultSender);
        this.accountPersistence.update((BaseModel)account);
        return account;
    }

    public Account updateFolders(long accountId, long inboxFolderId, long draftFolderId, long sentFolderId, long trashFolderId) throws PortalException {
        Account account = this.accountPersistence.findByPrimaryKey(accountId);
        account.setModifiedDate(new Date());
        account.setInboxFolderId(inboxFolderId);
        account.setDraftFolderId(draftFolderId);
        account.setSentFolderId(sentFolderId);
        account.setTrashFolderId(trashFolderId);
        this.accountPersistence.update((BaseModel)account);
        return account;
    }
}

