/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mail.reader.model;

import com.liferay.mail.reader.model.Message;
import java.util.List;

public class MessagesDisplay {
    private int _messageCount;
    private final List<Message> _messages;
    private final int _messagesPerPage;
    private final int _pageNumber;

    public MessagesDisplay(List<Message> messages, int pageNumber, int messagesPerPage, int messageCount) {
        this._messages = messages;
        this._pageNumber = pageNumber;
        this._messagesPerPage = messagesPerPage;
        this._messageCount = messageCount;
    }

    public int getEndMessageNumber() {
        int messageNumber = this._pageNumber * this._messagesPerPage;
        if (messageNumber > this._messageCount) {
            return this._messageCount;
        }
        return messageNumber;
    }

    public int getMessageCount() {
        return this._messageCount;
    }

    public List<Message> getMessages() {
        return this._messages;
    }

    public int getPageCount() {
        return (int)Math.ceil((double)this._messageCount / (double)this._messagesPerPage);
    }

    public int getPageNumber() {
        return this._pageNumber;
    }

    public int getStartMessageNumber() {
        if (this._messageCount == 0) {
            return 0;
        }
        return (this._pageNumber - 1) * this._messagesPerPage + 1;
    }
}

