/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.mail.reader.model;

import aQute.bnd.annotation.ProviderType;

import com.liferay.expando.kernel.model.ExpandoBridge;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.service.ServiceContext;

import java.io.Serializable;

import java.util.Date;

/**
 * The base model interface for the Folder service. Represents a row in the &quot;Mail_Folder&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link com.liferay.mail.reader.model.impl.FolderModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link com.liferay.mail.reader.model.impl.FolderImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see Folder
 * @see com.liferay.mail.reader.model.impl.FolderImpl
 * @see com.liferay.mail.reader.model.impl.FolderModelImpl
 * @generated
 */
@ProviderType
public interface FolderModel extends AuditedModel, BaseModel<Folder>,
	ShardedModel {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a folder model instance should use the {@link Folder} interface instead.
	 */

	/**
	 * Returns the primary key of this folder.
	 *
	 * @return the primary key of this folder
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this folder.
	 *
	 * @param primaryKey the primary key of this folder
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the folder ID of this folder.
	 *
	 * @return the folder ID of this folder
	 */
	public long getFolderId();

	/**
	 * Sets the folder ID of this folder.
	 *
	 * @param folderId the folder ID of this folder
	 */
	public void setFolderId(long folderId);

	/**
	 * Returns the company ID of this folder.
	 *
	 * @return the company ID of this folder
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this folder.
	 *
	 * @param companyId the company ID of this folder
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this folder.
	 *
	 * @return the user ID of this folder
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this folder.
	 *
	 * @param userId the user ID of this folder
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this folder.
	 *
	 * @return the user uuid of this folder
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this folder.
	 *
	 * @param userUuid the user uuid of this folder
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this folder.
	 *
	 * @return the user name of this folder
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this folder.
	 *
	 * @param userName the user name of this folder
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this folder.
	 *
	 * @return the create date of this folder
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this folder.
	 *
	 * @param createDate the create date of this folder
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this folder.
	 *
	 * @return the modified date of this folder
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this folder.
	 *
	 * @param modifiedDate the modified date of this folder
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the account ID of this folder.
	 *
	 * @return the account ID of this folder
	 */
	public long getAccountId();

	/**
	 * Sets the account ID of this folder.
	 *
	 * @param accountId the account ID of this folder
	 */
	public void setAccountId(long accountId);

	/**
	 * Returns the full name of this folder.
	 *
	 * @return the full name of this folder
	 */
	@AutoEscape
	public String getFullName();

	/**
	 * Sets the full name of this folder.
	 *
	 * @param fullName the full name of this folder
	 */
	public void setFullName(String fullName);

	/**
	 * Returns the display name of this folder.
	 *
	 * @return the display name of this folder
	 */
	@AutoEscape
	public String getDisplayName();

	/**
	 * Sets the display name of this folder.
	 *
	 * @param displayName the display name of this folder
	 */
	public void setDisplayName(String displayName);

	/**
	 * Returns the remote message count of this folder.
	 *
	 * @return the remote message count of this folder
	 */
	public int getRemoteMessageCount();

	/**
	 * Sets the remote message count of this folder.
	 *
	 * @param remoteMessageCount the remote message count of this folder
	 */
	public void setRemoteMessageCount(int remoteMessageCount);

	@Override
	public boolean isNew();

	@Override
	public void setNew(boolean n);

	@Override
	public boolean isCachedModel();

	@Override
	public void setCachedModel(boolean cachedModel);

	@Override
	public boolean isEscapedModel();

	@Override
	public Serializable getPrimaryKeyObj();

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj);

	@Override
	public ExpandoBridge getExpandoBridge();

	@Override
	public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

	@Override
	public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext);

	@Override
	public Object clone();

	@Override
	public int compareTo(Folder folder);

	@Override
	public int hashCode();

	@Override
	public CacheModel<Folder> toCacheModel();

	@Override
	public Folder toEscapedModel();

	@Override
	public Folder toUnescapedModel();

	@Override
	public String toString();

	@Override
	public String toXmlString();
}