/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.login.authentication.openid.connect.web.internal.portlet.action;

import com.liferay.portal.kernel.exception.UserEmailAddressException;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.sso.openid.connect.OpenIdConnect;
import com.liferay.portal.security.sso.openid.connect.OpenIdConnectServiceHandler;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"auth.token.ignore.mvc.action=true", "javax.portlet.name=com_liferay_login_web_portlet_FastLoginPortlet", "javax.portlet.name=com_liferay_login_web_portlet_LoginPortlet", "mvc.command.name=/login/openid_connect_response"}, service={MVCActionCommand.class})
public class OpenIdConnectLoginResponseMVCActionCommand
extends BaseMVCActionCommand {
    private static final String[] _ERRORS = new String[]{UserEmailAddressException.MustNotUseCompanyMx.class.getSimpleName(), "StrangersNotAllowedException"};
    @Reference
    private OpenIdConnect _openIdConnect;
    @Reference
    private OpenIdConnectServiceHandler _openIdConnectServiceHandler;
    @Reference
    private Portal _portal;

    public void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        HttpServletRequest httpServletRequest = this._portal.getOriginalServletRequest(this._portal.getHttpServletRequest((PortletRequest)actionRequest));
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (!this._openIdConnect.isEnabled(themeDisplay.getCompanyId())) {
            return;
        }
        String error = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"error");
        if (Validator.isNotNull((String)error)) {
            if (ArrayUtil.contains((Object[])_ERRORS, (Object)error)) {
                SessionErrors.add((PortletRequest)actionRequest, (String)error);
            } else {
                SessionErrors.add((PortletRequest)actionRequest, (String)"unknownError");
            }
            actionResponse.setRenderParameter("mvcRenderCommandName", "/login/openid_connect_request");
        } else {
            String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
            if (!Validator.isBlank((String)redirect)) {
                this.sendRedirect(actionRequest, actionResponse, redirect);
            } else {
                actionResponse.sendRedirect(themeDisplay.getPathMain());
            }
        }
    }
}

