/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.login.authentication.google.web.internal.portlet.action;

import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.struts.BaseStrutsAction;
import com.liferay.portal.kernel.struts.StrutsAction;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.sso.google.GoogleAuthorization;
import java.util.Arrays;
import java.util.List;
import javax.portlet.PortletMode;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"path=/portal/google_login"}, service={StrutsAction.class})
public class GoogleLoginAction
extends BaseStrutsAction {
    private static final String _REDIRECT_URI = "/portal/google_login?cmd=token";
    private static final List<String> _scopesLogin = Arrays.asList("email", "profile");
    @Reference
    private GoogleAuthorization _googleAuthorization;
    @Reference
    private Portal _portal;

    public String execute(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (!this._googleAuthorization.isEnabled(themeDisplay.getCompanyId())) {
            throw new PrincipalException.MustBeEnabled(themeDisplay.getCompanyId(), new String[]{GoogleAuthorization.class.getName()});
        }
        String cmd = ParamUtil.getString((HttpServletRequest)request, (String)"cmd");
        if (cmd.equals("login")) {
            String returnRequestUri = this.getReturnRequestUri(request);
            String loginRedirect = this._googleAuthorization.getLoginRedirect(themeDisplay.getCompanyId(), returnRequestUri, _scopesLogin);
            response.sendRedirect(loginRedirect);
        } else if (cmd.equals("token")) {
            HttpSession session = request.getSession();
            String authorizationCode = ParamUtil.getString((HttpServletRequest)request, (String)"code");
            if (Validator.isNotNull((String)authorizationCode)) {
                String returnRequestUri = this.getReturnRequestUri(request);
                User user = this._googleAuthorization.addOrUpdateUser(session, themeDisplay.getCompanyId(), authorizationCode, returnRequestUri, _scopesLogin);
                if (user != null && user.getStatus() == 6) {
                    this.sendUpdateAccountRedirect(request, response, user);
                    return null;
                }
                this.sendLoginRedirect(request, response);
                return null;
            }
            String error = ParamUtil.getString((HttpServletRequest)request, (String)"error");
            if (error.equals("access_denied")) {
                this.sendLoginRedirect(request, response);
                return null;
            }
        }
        return null;
    }

    protected String getReturnRequestUri(HttpServletRequest request) {
        return this._portal.getPortalURL(request) + this._portal.getPathMain() + _REDIRECT_URI;
    }

    protected void sendLoginRedirect(HttpServletRequest request, HttpServletResponse response) throws Exception {
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((HttpServletRequest)request, (String)"com_liferay_login_web_portlet_LoginPortlet", (String)"RENDER_PHASE");
        portletURL.setParameter("mvcRenderCommandName", "/login/login_redirect");
        portletURL.setWindowState(LiferayWindowState.POP_UP);
        response.sendRedirect(portletURL.toString());
    }

    protected void sendUpdateAccountRedirect(HttpServletRequest request, HttpServletResponse response, User user) throws Exception {
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((HttpServletRequest)request, (String)"com_liferay_login_web_portlet_LoginPortlet", (String)"RENDER_PHASE");
        portletURL.setParameter("saveLastPath", Boolean.FALSE.toString());
        portletURL.setParameter("mvcRenderCommandName", "/login/associate_google_user");
        LiferayPortletURL redirectURL = PortletURLFactoryUtil.create((HttpServletRequest)request, (String)"com_liferay_login_web_portlet_LoginPortlet", (String)"RENDER_PHASE");
        redirectURL.setParameter("mvcRenderCommandName", "/login/login_redirect");
        redirectURL.setParameter("emailAddress", user.getEmailAddress());
        redirectURL.setParameter("anonymousUser", Boolean.FALSE.toString());
        redirectURL.setPortletMode(PortletMode.VIEW);
        redirectURL.setWindowState(LiferayWindowState.POP_UP);
        portletURL.setParameter("redirect", redirectURL.toString());
        portletURL.setParameter("userId", String.valueOf(user.getUserId()));
        portletURL.setParameter("emailAddress", user.getEmailAddress());
        portletURL.setParameter("firstName", user.getFirstName());
        portletURL.setParameter("lastName", user.getLastName());
        portletURL.setPortletMode(PortletMode.VIEW);
        portletURL.setWindowState(LiferayWindowState.POP_UP);
        response.sendRedirect(portletURL.toString());
    }
}

