/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.learn;

import com.liferay.learn.LearnMessage;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.webcache.WebCacheItem;
import com.liferay.portal.kernel.webcache.WebCachePoolUtil;
import java.util.Objects;

public class LearnMessageUtil {
    private static final boolean _LEARN_RESOURCES_MODE_DEV = Objects.equals(PropsUtil.get((String)"learn.resources.mode"), "dev");
    private static final boolean _LEARN_RESOURCES_MODE_OFF = Objects.equals(PropsUtil.get((String)"learn.resources.mode"), "off");
    private static final Log _log = LogFactoryUtil.getLog(LearnMessageUtil.class);

    public static JSONObject getJSONObject(String resource) {
        return (JSONObject)WebCachePoolUtil.get((String)(JSONObjectWebCacheItem.class.getName() + "#" + resource), (WebCacheItem)new JSONObjectWebCacheItem(resource));
    }

    public static LearnMessage getLearnMessage(String key, String languageId, String resource) {
        JSONObject jsonObject = LearnMessageUtil.getJSONObject(resource);
        return new LearnMessage(jsonObject, key, languageId);
    }

    public static JSONObject getReactDataJSONObject(String resource) {
        JSONObject learnMessageJSONObject = LearnMessageUtil.getJSONObject(resource);
        return JSONUtil.put((String)resource, (Object)learnMessageJSONObject);
    }

    public static JSONObject getReactDataJSONObject(String[] resources) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        for (String resource : resources) {
            JSONObject learnMessageJSONObject = LearnMessageUtil.getJSONObject(resource);
            jsonObject.put(resource, learnMessageJSONObject);
        }
        return jsonObject;
    }

    private static class JSONObjectWebCacheItem
    implements WebCacheItem {
        private final String _resource;

        public JSONObjectWebCacheItem(String resource) {
            this._resource = resource;
        }

        public JSONObject convert(String key) {
            try {
                if (_LEARN_RESOURCES_MODE_OFF) {
                    return JSONFactoryUtil.createJSONObject();
                }
                StringBundler sb = new StringBundler(4);
                if (_LEARN_RESOURCES_MODE_DEV) {
                    sb.append("http://localhost:3062/");
                } else {
                    sb.append("https://s3.amazonaws.com");
                    sb.append("/learn-resources.liferay.com/");
                }
                sb.append(this._resource);
                sb.append(".json");
                String url = sb.toString();
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Reading " + url));
                }
                return JSONFactoryUtil.createJSONObject((String)HttpUtil.URLtoString((String)url));
            }
            catch (Exception exception) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)exception);
                }
                return JSONFactoryUtil.createJSONObject();
            }
        }

        public long getRefreshTime() {
            if (_LEARN_RESOURCES_MODE_DEV) {
                return 0L;
            }
            return 14400000L;
        }
    }
}

