/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.layout.uad.constants.LayoutUADConstants;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.LayoutRevision;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.LayoutRevisionLocalService;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseLayoutRevisionUADAnonymizer
extends DynamicQueryUADAnonymizer<LayoutRevision> {
    @Reference
    protected AssetEntryLocalService assetEntryLocalService;
    @Reference
    protected LayoutRevisionLocalService layoutRevisionLocalService;

    public void autoAnonymize(LayoutRevision layoutRevision, long userId, User anonymousUser) throws PortalException {
        if (layoutRevision.getUserId() == userId) {
            layoutRevision.setUserId(anonymousUser.getUserId());
            layoutRevision.setUserName(anonymousUser.getFullName());
            this.autoAnonymizeAssetEntry(layoutRevision, anonymousUser);
        }
        if (layoutRevision.getStatusByUserId() == userId) {
            layoutRevision.setStatusByUserId(anonymousUser.getUserId());
            layoutRevision.setStatusByUserName(anonymousUser.getFullName());
        }
        this.layoutRevisionLocalService.updateLayoutRevision(layoutRevision);
    }

    public void delete(LayoutRevision layoutRevision) throws PortalException {
        this.layoutRevisionLocalService.deleteLayoutRevision(layoutRevision);
    }

    public Class<LayoutRevision> getTypeClass() {
        return LayoutRevision.class;
    }

    protected void autoAnonymizeAssetEntry(LayoutRevision layoutRevision, User anonymousUser) {
        AssetEntry assetEntry = this.fetchAssetEntry(layoutRevision);
        if (assetEntry != null) {
            assetEntry.setUserId(anonymousUser.getUserId());
            assetEntry.setUserName(anonymousUser.getFullName());
            this.assetEntryLocalService.updateAssetEntry(assetEntry);
        }
    }

    protected ActionableDynamicQuery doGetActionableDynamicQuery() {
        return this.layoutRevisionLocalService.getActionableDynamicQuery();
    }

    protected String[] doGetUserIdFieldNames() {
        return LayoutUADConstants.USER_ID_FIELD_NAMES_LAYOUT_REVISION;
    }

    protected AssetEntry fetchAssetEntry(LayoutRevision layoutRevision) {
        return this.assetEntryLocalService.fetchEntry(LayoutRevision.class.getName(), layoutRevision.getLayoutRevisionId());
    }
}

