/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.layout.uad.constants.LayoutUADConstants;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.LayoutBranch;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.LayoutBranchLocalService;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseLayoutBranchUADAnonymizer
extends DynamicQueryUADAnonymizer<LayoutBranch> {
    @Reference
    protected AssetEntryLocalService assetEntryLocalService;
    @Reference
    protected LayoutBranchLocalService layoutBranchLocalService;

    public void autoAnonymize(LayoutBranch layoutBranch, long userId, User anonymousUser) throws PortalException {
        if (layoutBranch.getUserId() == userId) {
            layoutBranch.setUserId(anonymousUser.getUserId());
            layoutBranch.setUserName(anonymousUser.getFullName());
            this.autoAnonymizeAssetEntry(layoutBranch, anonymousUser);
        }
        this.layoutBranchLocalService.updateLayoutBranch(layoutBranch);
    }

    public void delete(LayoutBranch layoutBranch) throws PortalException {
        this.layoutBranchLocalService.deleteLayoutBranch(layoutBranch);
    }

    public Class<LayoutBranch> getTypeClass() {
        return LayoutBranch.class;
    }

    protected void autoAnonymizeAssetEntry(LayoutBranch layoutBranch, User anonymousUser) {
        AssetEntry assetEntry = this.fetchAssetEntry(layoutBranch);
        if (assetEntry != null) {
            assetEntry.setUserId(anonymousUser.getUserId());
            assetEntry.setUserName(anonymousUser.getFullName());
            this.assetEntryLocalService.updateAssetEntry(assetEntry);
        }
    }

    protected ActionableDynamicQuery doGetActionableDynamicQuery() {
        return this.layoutBranchLocalService.getActionableDynamicQuery();
    }

    protected String[] doGetUserIdFieldNames() {
        return LayoutUADConstants.USER_ID_FIELD_NAMES_LAYOUT_BRANCH;
    }

    protected AssetEntry fetchAssetEntry(LayoutBranch layoutBranch) {
        return this.assetEntryLocalService.fetchEntry(LayoutBranch.class.getName(), layoutBranch.getLayoutBranchId());
    }
}

