/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.layout.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.layout.uad.constants.LayoutUADConstants;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.LayoutRevision;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.LayoutRevisionLocalService;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;

import org.osgi.service.component.annotations.Reference;

/**
 * Provides the base implementation for the layout revision UAD anonymizer.
 *
 * <p>
 * This implementation exists only as a container for the default methods
 * generated by ServiceBuilder. All custom service methods should be put in
 * {@link LayoutRevisionUADAnonymizer}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @generated
 */
public abstract class BaseLayoutRevisionUADAnonymizer
	extends DynamicQueryUADAnonymizer<LayoutRevision> {

	@Override
	public void autoAnonymize(
			LayoutRevision layoutRevision, long userId, User anonymousUser)
		throws PortalException {

		if (layoutRevision.getUserId() == userId) {
			layoutRevision.setUserId(anonymousUser.getUserId());
			layoutRevision.setUserName(anonymousUser.getFullName());

			autoAnonymizeAssetEntry(layoutRevision, anonymousUser);
		}

		if (layoutRevision.getStatusByUserId() == userId) {
			layoutRevision.setStatusByUserId(anonymousUser.getUserId());
			layoutRevision.setStatusByUserName(anonymousUser.getFullName());
		}

		layoutRevisionLocalService.updateLayoutRevision(layoutRevision);
	}

	@Override
	public void delete(LayoutRevision layoutRevision) throws PortalException {
		layoutRevisionLocalService.deleteLayoutRevision(layoutRevision);
	}

	@Override
	public Class<LayoutRevision> getTypeClass() {
		return LayoutRevision.class;
	}

	protected void autoAnonymizeAssetEntry(
		LayoutRevision layoutRevision, User anonymousUser) {

		AssetEntry assetEntry = fetchAssetEntry(layoutRevision);

		if (assetEntry != null) {
			assetEntry.setUserId(anonymousUser.getUserId());
			assetEntry.setUserName(anonymousUser.getFullName());

			assetEntryLocalService.updateAssetEntry(assetEntry);
		}
	}

	@Override
	protected ActionableDynamicQuery doGetActionableDynamicQuery() {
		return layoutRevisionLocalService.getActionableDynamicQuery();
	}

	@Override
	protected String[] doGetUserIdFieldNames() {
		return LayoutUADConstants.USER_ID_FIELD_NAMES_LAYOUT_REVISION;
	}

	protected AssetEntry fetchAssetEntry(LayoutRevision layoutRevision) {
		return assetEntryLocalService.fetchEntry(
			LayoutRevision.class.getName(),
			layoutRevision.getLayoutRevisionId());
	}

	@Reference
	protected AssetEntryLocalService assetEntryLocalService;

	@Reference
	protected LayoutRevisionLocalService layoutRevisionLocalService;

}