/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.layout.uad.constants.LayoutUADConstants;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseLayoutUADAnonymizer
extends DynamicQueryUADAnonymizer<Layout> {
    @Reference
    protected AssetEntryLocalService assetEntryLocalService;
    @Reference
    protected LayoutLocalService layoutLocalService;

    public void autoAnonymize(Layout layout, long userId, User anonymousUser) throws PortalException {
        if (layout.getUserId() == userId) {
            layout.setUserId(anonymousUser.getUserId());
            layout.setUserName(anonymousUser.getFullName());
            this.autoAnonymizeAssetEntry(layout, anonymousUser);
        }
        this.layoutLocalService.updateLayout(layout);
    }

    public void delete(Layout layout) throws PortalException {
        this.layoutLocalService.deleteLayout(layout);
    }

    public Class<Layout> getTypeClass() {
        return Layout.class;
    }

    protected void autoAnonymizeAssetEntry(Layout layout, User anonymousUser) {
        AssetEntry assetEntry = this.fetchAssetEntry(layout);
        if (assetEntry != null) {
            assetEntry.setUserId(anonymousUser.getUserId());
            assetEntry.setUserName(anonymousUser.getFullName());
            this.assetEntryLocalService.updateAssetEntry(assetEntry);
        }
    }

    protected ActionableDynamicQuery doGetActionableDynamicQuery() {
        return this.layoutLocalService.getActionableDynamicQuery();
    }

    protected String[] doGetUserIdFieldNames() {
        return LayoutUADConstants.USER_ID_FIELD_NAMES_LAYOUT;
    }

    protected AssetEntry fetchAssetEntry(Layout layout) {
        return this.assetEntryLocalService.fetchEntry(Layout.class.getName(), layout.getPlid());
    }
}

