/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.layout.uad.constants.LayoutUADConstants;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.LayoutFriendlyURL;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.LayoutFriendlyURLLocalService;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseLayoutFriendlyURLUADAnonymizer
extends DynamicQueryUADAnonymizer<LayoutFriendlyURL> {
    @Reference
    protected AssetEntryLocalService assetEntryLocalService;
    @Reference
    protected LayoutFriendlyURLLocalService layoutFriendlyURLLocalService;

    public void autoAnonymize(LayoutFriendlyURL layoutFriendlyURL, long userId, User anonymousUser) throws PortalException {
        if (layoutFriendlyURL.getUserId() == userId) {
            layoutFriendlyURL.setUserId(anonymousUser.getUserId());
            layoutFriendlyURL.setUserName(anonymousUser.getFullName());
            this.autoAnonymizeAssetEntry(layoutFriendlyURL, anonymousUser);
        }
        this.layoutFriendlyURLLocalService.updateLayoutFriendlyURL(layoutFriendlyURL);
    }

    public void delete(LayoutFriendlyURL layoutFriendlyURL) throws PortalException {
        this.layoutFriendlyURLLocalService.deleteLayoutFriendlyURL(layoutFriendlyURL);
    }

    public Class<LayoutFriendlyURL> getTypeClass() {
        return LayoutFriendlyURL.class;
    }

    protected void autoAnonymizeAssetEntry(LayoutFriendlyURL layoutFriendlyURL, User anonymousUser) {
        AssetEntry assetEntry = this.fetchAssetEntry(layoutFriendlyURL);
        if (assetEntry != null) {
            assetEntry.setUserId(anonymousUser.getUserId());
            assetEntry.setUserName(anonymousUser.getFullName());
            this.assetEntryLocalService.updateAssetEntry(assetEntry);
        }
    }

    protected ActionableDynamicQuery doGetActionableDynamicQuery() {
        return this.layoutFriendlyURLLocalService.getActionableDynamicQuery();
    }

    protected String[] doGetUserIdFieldNames() {
        return LayoutUADConstants.USER_ID_FIELD_NAMES_LAYOUT_FRIENDLY_URL;
    }

    protected AssetEntry fetchAssetEntry(LayoutFriendlyURL layoutFriendlyURL) {
        return this.assetEntryLocalService.fetchEntry(LayoutFriendlyURL.class.getName(), layoutFriendlyURL.getLayoutFriendlyURLId());
    }
}

