<%--
/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */
--%>

<%@ include file="/init.jsp" %>

<%
OpenGraphSettingsDisplayContext openGraphSettingsDisplayContext = (OpenGraphSettingsDisplayContext)request.getAttribute(OpenGraphSettingsDisplayContext.class.getName());
%>

<liferay-util:html-top>
	<link href="<%= PortalUtil.getStaticResourceURL(request, PortalUtil.getPathProxy() + application.getContextPath() + "/css/main.css") %>" rel="stylesheet" type="text/css" />
</liferay-util:html-top>

<aui:field-wrapper cssClass="form-group">
	<aui:input id="openGraphEnabled" label="enable-open-graph" name="openGraphEnabled" type="checkbox" value="<%= openGraphSettingsDisplayContext.isOpenGraphEnabled() %>" />

	<p class="small text-secondary"><liferay-ui:message key="enable-open-graph-description" /></p>
</aui:field-wrapper>

<div class="open-graph-settings <%= openGraphSettingsDisplayContext.isOpenGraphEnabled() ? "" : "disabled" %>" id="<portlet:namespace />openGraphSettings">
	<h4 class="sheet-subtitle">
		<liferay-ui:message key="open-graph-image" />
	</h4>

	<p class="small text-secondary">
		<liferay-ui:message key="open-graph-image-description" />
	</p>

	<div class="form-group">
		<label class="control-label"><liferay-ui:message key="image" /></label>

		<div class="input-group mb-3">
			<div class="input-group-item">
				<input class="field form-control lfr-input-text" disabled="<%= !openGraphSettingsDisplayContext.isOpenGraphEnabled() %>" id="<portlet:namespace />openGraphImageTitle" name="<portlet:namespace />parentSiteTitle" placeholder="image" readonly="<%= true %>" type="text" value="<%= openGraphSettingsDisplayContext.getOpenGraphImageTitle() %>" />
			</div>

			<div class="input-group-item input-group-item-shrink">
				<button class="btn btn-secondary mr-1" id="<portlet:namespace />openGraphImageButton" type="button">
					<liferay-ui:message key="select" />
				</button>

				<button class="btn btn-secondary" id="<portlet:namespace />openGraphClearImageButton" type="button">
					<liferay-ui:message key="clear" />
				</button>
			</div>
		</div>

		<aui:model-context bean="<%= openGraphSettingsDisplayContext.getLayoutSEOSite() %>" model="<%= LayoutSEOSite.class %>" />

		<aui:input disabled="<%= !openGraphSettingsDisplayContext.isOpenGraphEnabled() || Validator.isNull(openGraphSettingsDisplayContext.getOpenGraphImageURL()) %>" helpMessage="open-graph-image-alt-description-help" label="open-graph-image-alt-description" name="openGraphImageAlt" placeholder="open-graph-alt-description" />
	</div>

	<aui:input id="openGraphImageFileEntryId" name="openGraphImageFileEntryId" type="hidden" value="<%= openGraphSettingsDisplayContext.getOpenGraphImageFileEntryId() %>" />

	<div class="form-group">
		<label>
			<div class="align-items-center d-flex">
				<liferay-ui:message key="preview" />

				<span>
					<clay:icon
						aria-label='<%= LanguageUtil.get(request, "preview-help") %>'
						cssClass="lfr-portal-tooltip ml-1"
						symbol="question-circle-full"
						title='<%= LanguageUtil.get(request, "preview-help") %>'
					/>
				</span>
			</div>
		</label>

		<div class="preview-seo preview-seo-og" dir="ltr">
			<div class="aspect-ratio aspect-ratio-191-to-100 bg-light mb-0 preview-seo-image">
				<div class="preview-seo-placeholder" id="<portlet:namespace />openGraphPreviewPlaceholder">
					<clay:icon
						cssClass="aspect-ratio-item aspect-ratio-item-center-middle aspect-ratio-item-fluid preview-seo-placeholder-icon"
						symbol="picture"
					/>

					<div class="preview-seo-placeholder-text"><liferay-ui:message key="open-graph-image-placeholder" /></div>
				</div>

				<img alt="" class="aspect-ratio-item aspect-ratio-item-center-middle aspect-ratio-item-flush <%= Validator.isNull(openGraphSettingsDisplayContext.getOpenGraphImageURL()) ? "hide" : "" %>" id="<portlet:namespace />openGraphPreviewImage" src="<%= openGraphSettingsDisplayContext.getOpenGraphImageURL() %>" />
			</div>
		</div>
	</div>
</div>

<liferay-frontend:component
	context='<%=
		HashMapBuilder.<String, Object>put(
			"uploadOpenGraphImageURL", openGraphSettingsDisplayContext.getItemSelectorURL()
		).build()
	%>'
	module="js/seo/openGraphSettings.es"
	servletContext="<%= application %>"
/>