/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import {toggleDisabled} from 'frontend-js-web';

import {previewSeoFireChange} from './PreviewSeoEvents.es';

export default function ({namespace}) {
	const canonicalURLEnabledCheck = document.getElementById(
		`${namespace}canonicalURLEnabled`
	);
	const canonicalURLField = document.getElementById(
		`${namespace}canonicalURL`
	);
	const canonicalURLFieldDefaultLocale = document.getElementById(
		`${namespace}canonicalURL_${Liferay.ThemeDisplay.getLanguageId()}`
	);
	const canonicalURLAlert = document.getElementById(
		`${namespace}canonicalURLAlert`
	);

	canonicalURLEnabledCheck.addEventListener('click', (event) => {
		const disabled = !event.target.checked;

		canonicalURLAlert.classList.toggle('hide');

		toggleDisabled(canonicalURLField, disabled);
		toggleDisabled(canonicalURLFieldDefaultLocale, disabled);

		if (!canonicalURLField.value && canonicalURLField.placeholder) {
			canonicalURLField.value = canonicalURLField.placeholder;
		}

		previewSeoFireChange(namespace, {
			disabled,
			type: 'url',
			value: canonicalURLField.value,
		});
	});
}
