/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import {openSelectionModal, toggleDisabled} from 'frontend-js-web';

export default function ({namespace, uploadOpenGraphImageURL}) {
	const openGraphImageButton = document.getElementById(
		`${namespace}openGraphImageButton`
	);

	const openGraphImageFileEntryId = document.getElementById(
		`${namespace}openGraphImageFileEntryId`
	);
	const openGraphImageTitle = document.getElementById(
		`${namespace}openGraphImageTitle`
	);
	const openGraphPreviewImage = document.getElementById(
		`${namespace}openGraphPreviewImage`
	);

	const openGraphImageAltField = document.getElementById(
		`${namespace}openGraphImageAlt`
	);
	const openGraphImageAltFieldDefaultLocale = document.getElementById(
		`${namespace}openGraphImageAlt_${Liferay.ThemeDisplay.getDefaultLanguageId()}`
	);
	const openGraphImageAltLabel = document.querySelector(
		`[for="${namespace}openGraphImageAlt"]`
	);

	openGraphImageButton.addEventListener('click', (event) => {
		event.preventDefault();

		openSelectionModal({
			buttonAddLabel: Liferay.Language.get('done'),
			onSelect: (selectedItem) => {
				if (selectedItem) {
					const itemValue = JSON.parse(selectedItem.value);

					openGraphImageFileEntryId.value = itemValue.fileEntryId;
					openGraphImageTitle.value = itemValue.title;
					openGraphPreviewImage.src = itemValue.url;
					openGraphPreviewImage.classList.remove('hide');

					toggleDisabled(openGraphImageAltField, false);
					toggleDisabled(openGraphImageAltFieldDefaultLocale, false);
					toggleDisabled(openGraphImageAltLabel, false);
				}
			},
			selectEventName: `${namespace}openGraphImageSelectedItem`,
			title: Liferay.Language.get('open-graph-image'),
			url: uploadOpenGraphImageURL,
		});
	});

	const openGraphClearImageButton = document.getElementById(
		`${namespace}openGraphClearImageButton`
	);

	openGraphClearImageButton.addEventListener('click', () => {
		openGraphImageFileEntryId.value = '';
		openGraphImageTitle.value = '';
		openGraphPreviewImage.src = '';

		toggleDisabled(openGraphImageAltField, true);
		toggleDisabled(openGraphImageAltFieldDefaultLocale, true);
		toggleDisabled(openGraphImageAltLabel, true);

		openGraphPreviewImage.classList.add('hide');
	});

	const openGraphEnabledCheck = document.getElementById(
		`${namespace}openGraphEnabled`
	);
	const openGraphSettings = document.getElementById(
		`${namespace}openGraphSettings`
	);

	openGraphEnabledCheck.addEventListener('click', (event) => {
		const disabled = !event.target.checked;
		const openGraphImageAltDisabled =
			disabled || !openGraphImageTitle.value;

		toggleDisabled(openGraphImageTitle, disabled);
		toggleDisabled(openGraphImageButton, disabled);
		toggleDisabled(openGraphClearImageButton, disabled);

		toggleDisabled(openGraphImageAltField, openGraphImageAltDisabled);
		toggleDisabled(
			openGraphImageAltFieldDefaultLocale,
			openGraphImageAltDisabled
		);
		toggleDisabled(openGraphImageAltLabel, openGraphImageAltDisabled);

		openGraphSettings.classList.toggle('disabled');
	});
}
