/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import {PropTypes} from 'prop-types';
import React from 'react';

import {FIELD_TYPES} from '../constants';
import MappingInput from './MappingInput';
import MappingSelector from './MappingSelector';

function MappingFields({fields, inputs, selectedSource}) {
	return inputs.map((props) => {
		const filteredFields = fields.filter(
			({type}) => type === props.fieldType
		);

		return props.fieldType === FIELD_TYPES.TEXT ? (
			<MappingInput
				fields={filteredFields}
				key={props.name}
				selectedSource={selectedSource}
				{...props}
			/>
		) : (
			<MappingSelector
				fields={filteredFields}
				key={props.name}
				selectedSource={selectedSource}
				{...props}
			/>
		);
	});
}

MappingFields.propTypes = {
	fields: PropTypes.arrayOf(
		PropTypes.shape({
			key: PropTypes.string,
			label: PropTypes.string,
		})
	).isRequired,
	inputs: PropTypes.arrayOf(
		PropTypes.shape({
			label: PropTypes.string,
			name: PropTypes.string,
			selectedFieldKey: PropTypes.string,
			value: PropTypes.string,
		})
	).isRequired,
};

export default MappingFields;
