/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import {PropTypes} from 'prop-types';
import React from 'react';

import MappingFields from './components/MappingFields';
import lang from './utils/lang';

export default function SeoMapping({
	description,
	fields,
	portletNamespace,
	selectedSource,
	title,
}) {
	return (
		<MappingFields
			fields={fields}
			inputs={[
				{
					fieldType: 'text',
					helpMessage: lang.sub(
						Liferay.Language.get(
							'map-a-x-field-it-will-be-used-as-x'
						),
						Liferay.Language.get('text'),
						Liferay.Language.get('html-title')
					),
					label: Liferay.Language.get('html-title'),
					name: `${portletNamespace}TypeSettingsProperties--mapped-title--`,
					value: title,
				},
				{
					component: 'textarea',
					fieldType: 'text',
					helpMessage: lang.sub(
						Liferay.Language.get(
							'map-a-x-field-it-will-be-used-as-x'
						),
						Liferay.Language.get('text'),
						Liferay.Language.get('description')
					),
					label: Liferay.Language.get('description'),
					name: `${portletNamespace}TypeSettingsProperties--mapped-description--`,
					value: description,
				},
			]}
			selectedSource={selectedSource}
		/>
	);
}

SeoMapping.propTypes = {
	description: PropTypes.string,
	fields: PropTypes.arrayOf(
		PropTypes.shape({
			key: PropTypes.string,
			label: PropTypes.string,
		})
	).isRequired,
	selectedSource: PropTypes.shape({
		classNameLabel: PropTypes.string,
		classTypeLabel: PropTypes.string,
	}).isRequired,
	title: PropTypes.string,
};
