/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.layout.seo.web.internal.template;

import com.liferay.layout.seo.kernel.LayoutSEOLinkManager;
import com.liferay.layout.seo.web.internal.util.TitleProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.template.TemplateConstants;
import com.liferay.portal.kernel.template.TemplateContextContributor;

import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Cristina González
 */
@Component(
	property = {
		"lang.type=" + TemplateConstants.LANG_TYPE_FTL,
		"type=" + TemplateContextContributor.TYPE_THEME
	},
	service = TemplateContextContributor.class
)
public class HTMLTitleTemplateContextContributor
	implements TemplateContextContributor {

	@Override
	public void prepare(
		Map<String, Object> contextObjects,
		HttpServletRequest httpServletRequest) {

		try {
			contextObjects.put(
				"htmlTitle", _titleProvider.getTitle(httpServletRequest));
		}
		catch (PortalException portalException) {
			_log.error("Unable to get HTML title ", portalException);
		}
	}

	@Activate
	protected void activate() {
		_titleProvider = new TitleProvider(_layoutSEOLinkManager);
	}

	private static final Log _log = LogFactoryUtil.getLog(
		HTMLTitleTemplateContextContributor.class);

	@Reference
	private LayoutSEOLinkManager _layoutSEOLinkManager;

	private TitleProvider _titleProvider;

}