/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.layout.seo.web.internal.configuration;

import aQute.bnd.annotation.metatype.Meta;

import com.liferay.portal.configuration.metatype.annotations.ExtendedObjectClassDefinition;

/**
 * @author Jamie Sammons
 */
@ExtendedObjectClassDefinition(category = "pages")
@Meta.OCD(
	description = "layout-seo-dynamic-rendering-configuration-description",
	id = "com.liferay.layout.seo.web.internal.configuration.LayoutSEODynamicRenderingConfiguration",
	localization = "content/Language",
	name = "layout-seo-dynamic-rendering-configuration-name"
)
public interface LayoutSEODynamicRenderingConfiguration {

	@Meta.AD(
		deflt = "false",
		name = "layout-seo-dynamic-rendering-configuration-enable-service",
		required = false
	)
	public boolean enabled();

	@Meta.AD(
		deflt = "",
		name = "layout-seo-dynamic-rendering-configuration-service-url",
		required = false
	)
	public String serviceURL();

	@Meta.AD(
		deflt = "W3C_Validator,applebot,baiduspider,bingbot,bitlybot,bitrix link preview,chrome-lighthouse,discordbot,embedly,facebookexternalhit,flipboard,google page speed,googlebot,linkedinbot,nuzzel,outbrain,pinterest/0.,pinterestbot,quora link preview,qwantify,redditbot,rogerbot,screaming frog,showyoubot,skypeuripreview,slackbot,telegrambot,tumblr,twitterbot,vkShare,whatsapp,xing-contenttabreceiver,yandex",
		name = "layout-seo-dynamic-rendering-configuration-crawler-user-agents",
		required = false
	)
	public String[] crawlerUserAgents();

	@Meta.AD(
		deflt = "",
		name = "layout-seo-dynamic-rendering-configuration-included-path",
		required = false
	)
	public String[] includedPaths();

	@Meta.AD(
		deflt = ".ai,.avi,.css,.dat,.dmg,.doc,.doc,.eot,.exe,.flv,.gif,.ico,.iso,.jpeg,.jpg,.js,.less,.m4a,.m4v,.mov,.mp3,.mp4,.mpeg,.mpg,.pdf,.png,.ppt,.psd,.rar,.rss,.svg,.swf,.tif,.torrent,.ttf,.txt,.wav,.wmv,.woff,.xls,.xml,.zip",
		name = "layout-seo-dynamic-rendering-configuration-ignored-extensions",
		required = false
	)
	public String[] ignoredExtensions();

}