/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import React from 'react';

const {useEffect} = React;

export default function useOnClickOutside(elements, handler) {
	useEffect(() => {
		const listener = (event) => {

			/**
			 * Detect clicks on elements or their descendent elements.
			 */
			const filtered = elements.filter(
				(element) => element && element.contains(event.target)
			);

			if (!filtered.length) {
				handler(event);
			}
		};

		document.addEventListener('mousedown', listener);
		document.addEventListener('touchstart', listener);

		return () => {
			document.removeEventListener('mousedown', listener);
			document.removeEventListener('touchstart', listener);
		};
	}, [elements, handler]);
}
