/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.layout.seo.web.internal.util;

import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutConstants;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.service.LayoutService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;

/**
 * @author Alejandro Tardín
 */
public class LayoutTypeSettingsUtil {

	public static Layout updateTypeSettings(
			Layout layout, LayoutService layoutService,
			UnicodeProperties typeSettingsUnicodeProperties)
		throws Exception {

		UnicodeProperties layoutTypeSettingsUnicodeProperties =
			layout.getTypeSettingsProperties();

		String type = layout.getType();

		if (type.equals(LayoutConstants.TYPE_PORTLET)) {
			layoutTypeSettingsUnicodeProperties.putAll(
				typeSettingsUnicodeProperties);

			boolean layoutCustomizable = GetterUtil.getBoolean(
				layoutTypeSettingsUnicodeProperties.get(
					LayoutConstants.CUSTOMIZABLE_LAYOUT));

			if (!layoutCustomizable) {
				LayoutTypePortlet layoutTypePortlet =
					(LayoutTypePortlet)layout.getLayoutType();

				layoutTypePortlet.removeCustomization(
					layoutTypeSettingsUnicodeProperties);
			}

			return layoutService.updateLayout(
				layout.getGroupId(), layout.isPrivateLayout(),
				layout.getLayoutId(),
				layoutTypeSettingsUnicodeProperties.toString());
		}

		layoutTypeSettingsUnicodeProperties.putAll(
			typeSettingsUnicodeProperties);

		layoutTypeSettingsUnicodeProperties.putAll(
			layout.getTypeSettingsProperties());

		return layoutService.updateLayout(
			layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(),
			layoutTypeSettingsUnicodeProperties.toString());
	}

}