/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import {toggleDisabled} from 'frontend-js-web';

import {previewSeoFireChange} from './PreviewSeoEvents.es';

export default function ({namespace}) {
	var canonicalURLEnabledCheck = document.getElementById(
		`${namespace}canonicalURLEnabled`
	);
	var canonicalURLField = document.getElementById(`${namespace}canonicalURL`);
	var canonicalURLFieldDefaultLocale = document.getElementById(
		`${namespace}canonicalURL_${Liferay.ThemeDisplay.getLanguageId()}`
	);
	var canonicalURLAlert = document.getElementById(
		`${namespace}canonicalURLAlert`
	);

	canonicalURLEnabledCheck.addEventListener('click', (event) => {
		var disabled = !event.target.checked;

		canonicalURLAlert.classList.toggle('hide');

		toggleDisabled(canonicalURLField, disabled);

		toggleDisabled(canonicalURLFieldDefaultLocale, disabled);

		previewSeoFireChange(namespace, {
			disabled,
			type: 'url',
			value: canonicalURLField.value,
		});
	});
}
