/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import {PropTypes} from 'prop-types';
import React from 'react';

import MappingInput from './MappingInput';

function MappingInputs({fields, inputs, selectedSource}) {
	return (
		<>
			{inputs.map((props) => (
				<MappingInput
					initialFields={fields}
					key={props.name}
					selectedSource={selectedSource}
					{...props}
				/>
			))}
		</>
	);
}

MappingInputs.propTypes = {
	fields: PropTypes.arrayOf(
		PropTypes.shape({
			key: PropTypes.string,
			label: PropTypes.string,
		})
	).isRequired,
	inputs: PropTypes.arrayOf(
		PropTypes.shape({
			label: PropTypes.string,
			name: PropTypes.string,
			selectedFieldKey: PropTypes.string,
		})
	).isRequired,
};

export default MappingInputs;
