/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import {PropTypes} from 'prop-types';
import React from 'react';

import MappingInputs from './components/MappingInputs';
import lang from './utils/lang';

export default function OpenGraphMapping({
	fields,
	openGraphDescription,
	openGraphImage,
	openGraphImageAlt,
	openGraphTitle,
	portletNamespace,
	selectedSource,
}) {
	return (
		<MappingInputs
			fields={fields}
			inputs={[
				{
					fieldType: 'text',
					helpMessage: lang.sub(
						Liferay.Language.get(
							'map-a-x-field-it-will-be-used-as-x'
						),
						Liferay.Language.get('text'),
						Liferay.Language.get('title')
					),
					label: Liferay.Language.get('title'),
					name: `${portletNamespace}TypeSettingsProperties--mapped-openGraphTitle--`,
					selectedFieldKey: openGraphTitle,
				},
				{
					fieldType: 'text',
					helpMessage: lang.sub(
						Liferay.Language.get(
							'map-a-x-field-it-will-be-used-as-x'
						),
						Liferay.Language.get('text'),
						Liferay.Language.get('description')
					),
					label: Liferay.Language.get('description'),
					name: `${portletNamespace}TypeSettingsProperties--mapped-openGraphDescription--`,
					selectedFieldKey: openGraphDescription,
				},
				{
					fieldType: 'image',
					helpMessage: lang.sub(
						Liferay.Language.get(
							'map-a-x-field-it-will-be-used-as-x'
						),
						Liferay.Language.get('image'),
						Liferay.Language.get('image')
					),
					label: Liferay.Language.get('image'),
					name: `${portletNamespace}TypeSettingsProperties--mapped-openGraphImage--`,
					selectedFieldKey: openGraphImage,
				},
				{
					fieldType: 'text',
					helpMessage: lang.sub(
						Liferay.Language.get(
							'map-a-x-field-it-will-be-used-as-x'
						),
						Liferay.Language.get('text'),
						Liferay.Language.get('open-graph-image-alt-description')
					),
					label: Liferay.Language.get(
						'open-graph-image-alt-description'
					),
					name: `${portletNamespace}TypeSettingsProperties--mapped-openGraphImageAlt--`,
					selectedFieldKey: openGraphImageAlt,
				},
			]}
			selectedSource={selectedSource}
		/>
	);
}

OpenGraphMapping.propTypes = {
	fields: PropTypes.arrayOf(
		PropTypes.shape({
			key: PropTypes.string,
			label: PropTypes.string,
		})
	).isRequired,
	openGraphDescription: PropTypes.string,
	openGraphImage: PropTypes.string,
	openGraphImageAlt: PropTypes.string,
	openGraphTitle: PropTypes.string,
	selectedSource: PropTypes.shape({
		classNameLabel: PropTypes.string,
		classTypeLabel: PropTypes.string,
	}).isRequired,
};
