/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.page.template.service.impl;

import com.liferay.asset.kernel.NoSuchClassTypeException;
import com.liferay.dynamic.data.mapping.model.DDMStructureLink;
import com.liferay.dynamic.data.mapping.service.DDMStructureLinkLocalService;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.info.display.contributor.InfoDisplayContributor;
import com.liferay.info.display.contributor.InfoDisplayContributorTracker;
import com.liferay.layout.page.template.exception.LayoutPageTemplateEntryNameException;
import com.liferay.layout.page.template.internal.validator.LayoutPageTemplateEntryValidator;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.base.LayoutPageTemplateEntryLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.NoSuchClassNameException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.LayoutPrototypeLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.staging.StagingGroupHelper;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.layout.page.template.model.LayoutPageTemplateEntry"}, service={AopService.class})
public class LayoutPageTemplateEntryLocalServiceImpl
extends LayoutPageTemplateEntryLocalServiceBaseImpl {
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private DDMStructureLinkLocalService _ddmStructureLinkLocalService;
    @Reference
    private FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    @Reference
    private InfoDisplayContributorTracker _infoDisplayContributorTracker;
    @Reference
    private LayoutPrototypeLocalService _layoutPrototypeLocalService;
    @Reference
    private StagingGroupHelper _stagingGroupHelper;

    public LayoutPageTemplateEntry addGlobalLayoutPageTemplateEntry(LayoutPrototype layoutPrototype) throws PortalException {
        Company company = this._companyLocalService.getCompany(layoutPrototype.getCompanyId());
        return this.addLayoutPageTemplateEntry(company.getGroupId(), layoutPrototype);
    }

    public LayoutPageTemplateEntry addLayoutPageTemplateEntry(LayoutPrototype layoutPrototype) throws PortalException {
        long scopeGroupId;
        Company company = this._companyLocalService.getCompany(layoutPrototype.getCompanyId());
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        long groupId = company.getGroupId();
        if (serviceContext != null && (scopeGroupId = serviceContext.getScopeGroupId()) != 0L) {
            groupId = scopeGroupId;
        }
        return this.addLayoutPageTemplateEntry(groupId, layoutPrototype);
    }

    @Deprecated
    public LayoutPageTemplateEntry addLayoutPageTemplateEntry(long userId, long groupId, long layoutPageTemplateCollectionId, long classNameId, long classTypeId, String name, int type, boolean defaultTemplate, long layoutPrototypeId, long previewFileEntryId, int status, ServiceContext serviceContext) throws PortalException {
        return this.addLayoutPageTemplateEntry(userId, groupId, layoutPageTemplateCollectionId, classNameId, classTypeId, name, type, defaultTemplate, 0L, 0L, 0L, status, serviceContext);
    }

    public LayoutPageTemplateEntry addLayoutPageTemplateEntry(long userId, long groupId, long layoutPageTemplateCollectionId, long classNameId, long classTypeId, String name, int type, boolean defaultTemplate, long layoutPrototypeId, long previewFileEntryId, long plid, int status, ServiceContext serviceContext) throws PortalException {
        Layout layout;
        User user = this.userLocalService.getUser(userId);
        this.validate(groupId, name);
        long layoutPageTemplateEntryId = this.counterLocalService.increment();
        LayoutPageTemplateEntry layoutPageTemplateEntry = this.layoutPageTemplateEntryPersistence.create(layoutPageTemplateEntryId);
        layoutPageTemplateEntry.setUuid(serviceContext.getUuid());
        layoutPageTemplateEntry.setGroupId(groupId);
        layoutPageTemplateEntry.setCompanyId(user.getCompanyId());
        layoutPageTemplateEntry.setUserId(user.getUserId());
        layoutPageTemplateEntry.setUserName(user.getFullName());
        layoutPageTemplateEntry.setCreateDate(serviceContext.getCreateDate(new Date()));
        layoutPageTemplateEntry.setModifiedDate(serviceContext.getModifiedDate(new Date()));
        layoutPageTemplateEntry.setLayoutPageTemplateCollectionId(layoutPageTemplateCollectionId);
        layoutPageTemplateEntry.setClassNameId(classNameId);
        layoutPageTemplateEntry.setClassTypeId(classTypeId);
        layoutPageTemplateEntry.setName(name);
        layoutPageTemplateEntry.setType(type);
        layoutPageTemplateEntry.setPreviewFileEntryId(previewFileEntryId);
        layoutPageTemplateEntry.setDefaultTemplate(defaultTemplate);
        layoutPageTemplateEntry.setLayoutPrototypeId(layoutPrototypeId);
        if (plid == 0L && (layout = this._addLayout(userId, groupId, name, type, serviceContext)) != null) {
            plid = layout.getPlid();
        }
        layoutPageTemplateEntry.setPlid(plid);
        layoutPageTemplateEntry.setStatus(status);
        layoutPageTemplateEntry.setStatusByUserId(userId);
        layoutPageTemplateEntry.setStatusByUserName(user.getScreenName());
        layoutPageTemplateEntry.setStatusDate(new Date());
        layoutPageTemplateEntry = (LayoutPageTemplateEntry)this.layoutPageTemplateEntryPersistence.update((BaseModel)layoutPageTemplateEntry);
        this.resourceLocalService.addResources(layoutPageTemplateEntry.getCompanyId(), layoutPageTemplateEntry.getGroupId(), layoutPageTemplateEntry.getUserId(), LayoutPageTemplateEntry.class.getName(), layoutPageTemplateEntry.getLayoutPageTemplateEntryId(), false, true, true);
        return layoutPageTemplateEntry;
    }

    public LayoutPageTemplateEntry addLayoutPageTemplateEntry(long userId, long groupId, long layoutPageTemplateCollectionId, long classNameId, long classTypeId, String name, int type, int status, ServiceContext serviceContext) throws PortalException {
        this.validate(classNameId, classTypeId, groupId, serviceContext.getLocale());
        LayoutPageTemplateEntry layoutPageTemplateEntry = this.addLayoutPageTemplateEntry(userId, groupId, layoutPageTemplateCollectionId, classNameId, classTypeId, name, type, false, 0L, 0L, 0L, status, serviceContext);
        this._ddmStructureLinkLocalService.addStructureLink(this.classNameLocalService.getClassNameId(LayoutPageTemplateEntry.class), layoutPageTemplateEntry.getLayoutPageTemplateEntryId(), classTypeId);
        return layoutPageTemplateEntry;
    }

    public LayoutPageTemplateEntry addLayoutPageTemplateEntry(long userId, long groupId, long layoutPageTemplateCollectionId, String name, int type, int status, ServiceContext serviceContext) throws PortalException {
        return this.addLayoutPageTemplateEntry(userId, groupId, layoutPageTemplateCollectionId, 0L, 0L, name, type, false, 0L, 0L, 0L, status, serviceContext);
    }

    @Deprecated
    public LayoutPageTemplateEntry addLayoutPageTemplateEntry(long userId, long groupId, long layoutPageTemplateCollectionId, String name, int type, long layoutPrototypeId, int status, ServiceContext serviceContext) throws PortalException {
        return this.addLayoutPageTemplateEntry(userId, groupId, layoutPageTemplateCollectionId, 0L, 0L, name, type, false, 0L, 0L, 0L, status, serviceContext);
    }

    @Deprecated
    public LayoutPageTemplateEntry addLayoutPageTemplateEntry(long userId, long groupId, long layoutPageTemplateCollectionId, String name, int type, long layoutPrototypeId, long previewFileEntryId, int status, ServiceContext serviceContext) throws PortalException {
        return this.addLayoutPageTemplateEntry(userId, groupId, layoutPageTemplateCollectionId, 0L, 0L, name, type, false, 0L, 0L, 0L, status, serviceContext);
    }

    @Deprecated
    public LayoutPageTemplateEntry addLayoutPageTemplateEntry(long userId, long groupId, long layoutPageTemplateCollectionId, String name, int type, ServiceContext serviceContext) throws PortalException {
        return this.addLayoutPageTemplateEntry(userId, groupId, layoutPageTemplateCollectionId, 0L, 0L, name, type, false, 0L, 0L, 0L, 2, serviceContext);
    }

    @Deprecated
    public LayoutPageTemplateEntry addLayoutPageTemplateEntry(long userId, long groupId, long layoutPageTemplateCollectionId, String name, ServiceContext serviceContext) throws PortalException {
        return this.addLayoutPageTemplateEntry(userId, groupId, layoutPageTemplateCollectionId, 0L, 0L, name, 0, false, 0L, 0L, 0L, 2, serviceContext);
    }

    @Override
    public LayoutPageTemplateEntry deleteLayoutPageTemplateEntry(LayoutPageTemplateEntry layoutPageTemplateEntry) throws PortalException {
        LayoutPrototype layoutPrototype;
        long layoutPrototypeId;
        this.layoutPageTemplateEntryPersistence.remove((BaseModel)layoutPageTemplateEntry);
        this.resourceLocalService.deleteResource(layoutPageTemplateEntry.getCompanyId(), LayoutPageTemplateEntry.class.getName(), 4, layoutPageTemplateEntry.getLayoutPageTemplateEntryId());
        Layout layout = this.layoutLocalService.fetchLayout(layoutPageTemplateEntry.getPlid());
        LayoutSet layoutSet = this.layoutSetLocalService.fetchLayoutSet(layoutPageTemplateEntry.getGroupId(), false);
        if (layout != null && layoutSet != null) {
            this.layoutLocalService.deleteLayout(layout);
        }
        if (!this._stagingGroupHelper.isLocalStagingGroup(layoutPageTemplateEntry.getGroupId()) && (layoutPrototypeId = layoutPageTemplateEntry.getLayoutPrototypeId()) > 0L && (layoutPrototype = this._layoutPrototypeLocalService.fetchLayoutPrototype(layoutPrototypeId)) != null) {
            this._layoutPrototypeLocalService.deleteLayoutPrototype(layoutPrototypeId);
        }
        if (Objects.equals(layoutPageTemplateEntry.getType(), 1) && layoutPageTemplateEntry.getClassTypeId() > 0L) {
            this._ddmStructureLinkLocalService.deleteStructureLinks(this.classNameLocalService.getClassNameId(LayoutPageTemplateEntry.class), layoutPageTemplateEntry.getLayoutPageTemplateEntryId());
        }
        return layoutPageTemplateEntry;
    }

    @Override
    public LayoutPageTemplateEntry deleteLayoutPageTemplateEntry(long layoutPageTemplateEntryId) throws PortalException {
        return this.deleteLayoutPageTemplateEntry(this.getLayoutPageTemplateEntry(layoutPageTemplateEntryId));
    }

    public LayoutPageTemplateEntry fetchDefaultLayoutPageTemplateEntry(long groupId, long classNameId, long classTypeId) {
        return this.layoutPageTemplateEntryPersistence.fetchByG_C_C_D_First(groupId, classNameId, classTypeId, true, null);
    }

    public LayoutPageTemplateEntry fetchFirstLayoutPageTemplateEntry(long layoutPrototypeId) {
        return this.layoutPageTemplateEntryPersistence.fetchByLayoutPrototypeId_First(layoutPrototypeId, null);
    }

    @Override
    public LayoutPageTemplateEntry fetchLayoutPageTemplateEntry(long layoutPageTemplateEntryId) {
        return this.layoutPageTemplateEntryPersistence.fetchByPrimaryKey(layoutPageTemplateEntryId);
    }

    public LayoutPageTemplateEntry fetchLayoutPageTemplateEntry(long groupId, String name) {
        return this.layoutPageTemplateEntryPersistence.fetchByG_N(groupId, name);
    }

    public LayoutPageTemplateEntry fetchLayoutPageTemplateEntryByPlid(long plid) {
        return this.layoutPageTemplateEntryPersistence.fetchByPlid(plid);
    }

    public List<LayoutPageTemplateEntry> getLayoutPageTemplateEntries(long groupId) {
        return this.layoutPageTemplateEntryPersistence.findByGroupId(groupId);
    }

    public List<LayoutPageTemplateEntry> getLayoutPageTemplateEntries(long groupId, long layoutPageTemplateCollectionId) {
        return this.getLayoutPageTemplateEntries(groupId, layoutPageTemplateCollectionId, -1);
    }

    public List<LayoutPageTemplateEntry> getLayoutPageTemplateEntries(long groupId, long layoutPageTemplateCollectionId, int status) {
        if (status == -1) {
            return this.layoutPageTemplateEntryPersistence.findByG_L(groupId, layoutPageTemplateCollectionId);
        }
        return this.layoutPageTemplateEntryPersistence.findByG_L_S(groupId, layoutPageTemplateCollectionId, status);
    }

    public List<LayoutPageTemplateEntry> getLayoutPageTemplateEntries(long groupId, long layoutPageTemplateCollectionId, int start, int end) {
        return this.getLayoutPageTemplateEntries(groupId, layoutPageTemplateCollectionId, -1, start, end);
    }

    public List<LayoutPageTemplateEntry> getLayoutPageTemplateEntries(long groupId, long layoutPageTemplateCollectionId, int status, int start, int end) {
        if (status == -1) {
            return this.layoutPageTemplateEntryPersistence.findByG_L(groupId, layoutPageTemplateCollectionId, start, end);
        }
        return this.layoutPageTemplateEntryPersistence.findByG_L_S(groupId, layoutPageTemplateCollectionId, status, start, end);
    }

    public List<LayoutPageTemplateEntry> getLayoutPageTemplateEntries(long groupId, long layoutPageTemplateCollectionId, int status, int start, int end, OrderByComparator<LayoutPageTemplateEntry> orderByComparator) {
        if (status == -1) {
            return this.layoutPageTemplateEntryPersistence.findByG_L(groupId, layoutPageTemplateCollectionId, start, end, orderByComparator);
        }
        return this.layoutPageTemplateEntryPersistence.findByG_L_S(groupId, layoutPageTemplateCollectionId, status, start, end, orderByComparator);
    }

    public List<LayoutPageTemplateEntry> getLayoutPageTemplateEntries(long groupId, long layoutPageTemplateCollectionId, int start, int end, OrderByComparator<LayoutPageTemplateEntry> orderByComparator) {
        return this.getLayoutPageTemplateEntries(groupId, layoutPageTemplateCollectionId, -1, start, end, orderByComparator);
    }

    public List<LayoutPageTemplateEntry> getLayoutPageTemplateEntries(long groupId, long layoutPageTemplateCollectionId, String name, int status, int start, int end, OrderByComparator<LayoutPageTemplateEntry> orderByComparator) {
        if (status == -1) {
            if (Validator.isNull((String)name)) {
                return this.layoutPageTemplateEntryPersistence.findByG_L(groupId, layoutPageTemplateCollectionId, start, end, orderByComparator);
            }
            return this.layoutPageTemplateEntryPersistence.findByG_L_LikeN(groupId, layoutPageTemplateCollectionId, name, start, end, orderByComparator);
        }
        if (Validator.isNull((String)name)) {
            return this.layoutPageTemplateEntryPersistence.findByG_L_S(groupId, layoutPageTemplateCollectionId, status, start, end, orderByComparator);
        }
        return this.layoutPageTemplateEntryPersistence.findByG_L_LikeN_S(groupId, layoutPageTemplateCollectionId, name, status, start, end, orderByComparator);
    }

    public List<LayoutPageTemplateEntry> getLayoutPageTemplateEntries(long groupId, long layoutPageTemplateCollectionId, String name, int start, int end, OrderByComparator<LayoutPageTemplateEntry> orderByComparator) {
        return this.getLayoutPageTemplateEntries(groupId, layoutPageTemplateCollectionId, name, -1, start, end, orderByComparator);
    }

    public List<LayoutPageTemplateEntry> getLayoutPageTemplateEntriesByLayoutPrototypeId(long layoutPrototypeId) {
        return this.layoutPageTemplateEntryPersistence.findByLayoutPrototypeId(layoutPrototypeId);
    }

    public LayoutPageTemplateEntry updateLayoutPageTemplateEntry(long layoutPageTemplateEntryId, boolean defaultTemplate) {
        LayoutPageTemplateEntry layoutPageTemplateEntry = this.fetchLayoutPageTemplateEntry(layoutPageTemplateEntryId);
        if (layoutPageTemplateEntry == null) {
            return null;
        }
        LayoutPageTemplateEntry defaultLayoutPageTemplateEntry = this.layoutPageTemplateEntryPersistence.fetchByG_C_C_D_First(layoutPageTemplateEntry.getGroupId(), layoutPageTemplateEntry.getClassNameId(), layoutPageTemplateEntry.getClassTypeId(), true, null);
        if (defaultTemplate && defaultLayoutPageTemplateEntry != null && defaultLayoutPageTemplateEntry.getLayoutPageTemplateEntryId() != layoutPageTemplateEntryId) {
            layoutPageTemplateEntry.setModifiedDate(new Date());
            defaultLayoutPageTemplateEntry.setDefaultTemplate(false);
            this.layoutPageTemplateEntryLocalService.updateLayoutPageTemplateEntry(defaultLayoutPageTemplateEntry);
        }
        layoutPageTemplateEntry.setModifiedDate(new Date());
        layoutPageTemplateEntry.setDefaultTemplate(defaultTemplate);
        this.layoutPageTemplateEntryLocalService.updateLayoutPageTemplateEntry(layoutPageTemplateEntry);
        return layoutPageTemplateEntry;
    }

    public LayoutPageTemplateEntry updateLayoutPageTemplateEntry(long layoutPageTemplateEntryId, long previewFileEntryId) throws PortalException {
        LayoutPageTemplateEntry layoutPageTemplateEntry = this.layoutPageTemplateEntryPersistence.findByPrimaryKey(layoutPageTemplateEntryId);
        layoutPageTemplateEntry.setModifiedDate(new Date());
        layoutPageTemplateEntry.setPreviewFileEntryId(previewFileEntryId);
        return this.layoutPageTemplateEntryLocalService.updateLayoutPageTemplateEntry(layoutPageTemplateEntry);
    }

    @Deprecated
    public LayoutPageTemplateEntry updateLayoutPageTemplateEntry(long layoutPageTemplateEntryId, long classNameId, long classTypeId) throws PortalException {
        List ddmStructureLinks = this._ddmStructureLinkLocalService.getStructureLinks(this.classNameLocalService.getClassNameId(LayoutPageTemplateEntry.class), layoutPageTemplateEntryId);
        if (ListUtil.isNotEmpty((List)ddmStructureLinks)) {
            DDMStructureLink ddmStructureLink = (DDMStructureLink)ddmStructureLinks.get(0);
            this._ddmStructureLinkLocalService.deleteDDMStructureLink(ddmStructureLink);
        }
        LayoutPageTemplateEntry layoutPageTemplateEntry = this.layoutPageTemplateEntryPersistence.findByPrimaryKey(layoutPageTemplateEntryId);
        layoutPageTemplateEntry.setModifiedDate(new Date());
        layoutPageTemplateEntry.setClassNameId(classNameId);
        layoutPageTemplateEntry.setClassTypeId(classTypeId);
        Layout layout = null;
        if (layoutPageTemplateEntry.getPlid() == 0L) {
            layout = this._addLayout(layoutPageTemplateEntry.getUserId(), layoutPageTemplateEntry.getGroupId(), layoutPageTemplateEntry.getName(), layoutPageTemplateEntry.getType(), ServiceContextThreadLocal.getServiceContext());
        }
        if (layout != null) {
            layoutPageTemplateEntry.setPlid(layout.getPlid());
        }
        layoutPageTemplateEntry = (LayoutPageTemplateEntry)this.layoutPageTemplateEntryPersistence.update((BaseModel)layoutPageTemplateEntry);
        this._ddmStructureLinkLocalService.addStructureLink(this.classNameLocalService.getClassNameId(LayoutPageTemplateEntry.class), layoutPageTemplateEntryId, classTypeId);
        return layoutPageTemplateEntry;
    }

    public LayoutPageTemplateEntry updateLayoutPageTemplateEntry(long userId, long layoutPageTemplateEntryId, String name, int status) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        LayoutPageTemplateEntry layoutPageTemplateEntry = this.layoutPageTemplateEntryPersistence.findByPrimaryKey(layoutPageTemplateEntryId);
        if (!Objects.equals(layoutPageTemplateEntry.getName(), name)) {
            this.validate(layoutPageTemplateEntry.getGroupId(), name);
        }
        layoutPageTemplateEntry.setModifiedDate(new Date());
        layoutPageTemplateEntry.setName(name);
        layoutPageTemplateEntry.setStatus(status);
        layoutPageTemplateEntry.setStatusByUserId(userId);
        layoutPageTemplateEntry.setStatusByUserName(user.getScreenName());
        layoutPageTemplateEntry.setStatusDate(new Date());
        return this.layoutPageTemplateEntryLocalService.updateLayoutPageTemplateEntry(layoutPageTemplateEntry);
    }

    public LayoutPageTemplateEntry updateLayoutPageTemplateEntry(long layoutPageTemplateEntryId, String name) throws PortalException {
        LayoutPageTemplateEntry layoutPageTemplateEntry = this.layoutPageTemplateEntryPersistence.findByPrimaryKey(layoutPageTemplateEntryId);
        if (Objects.equals(layoutPageTemplateEntry.getName(), name)) {
            return layoutPageTemplateEntry;
        }
        this.validate(layoutPageTemplateEntry.getGroupId(), name);
        layoutPageTemplateEntry.setModifiedDate(new Date());
        layoutPageTemplateEntry.setName(name);
        layoutPageTemplateEntry = this.layoutPageTemplateEntryLocalService.updateLayoutPageTemplateEntry(layoutPageTemplateEntry);
        Map<Locale, String> titleMap = Collections.singletonMap(LocaleUtil.getSiteDefault(), name);
        Layout draftLayout = this.layoutLocalService.fetchLayout(this.classNameLocalService.getClassNameId(Layout.class), layoutPageTemplateEntry.getPlid());
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            serviceContext = new ServiceContext();
        }
        serviceContext.setAttribute("layout.instanceable.allowed", (Serializable)Boolean.TRUE);
        this.layoutLocalService.updateLayout(draftLayout.getGroupId(), draftLayout.isPrivateLayout(), draftLayout.getLayoutId(), draftLayout.getParentLayoutId(), titleMap, titleMap, draftLayout.getDescriptionMap(), draftLayout.getKeywordsMap(), draftLayout.getRobotsMap(), draftLayout.getType(), draftLayout.isHidden(), draftLayout.getFriendlyURLMap(), draftLayout.getIconImage(), null, serviceContext);
        return layoutPageTemplateEntry;
    }

    public LayoutPageTemplateEntry updateLayoutPageTemplateEntry(long layoutPageTemplateEntryId, String name, long[] fragmentEntryIds, String editableValues, ServiceContext serviceContext) throws PortalException {
        LayoutPageTemplateEntry layoutPageTemplateEntry = this.layoutPageTemplateEntryPersistence.findByPrimaryKey(layoutPageTemplateEntryId);
        if (!Objects.equals(layoutPageTemplateEntry.getName(), name)) {
            this.validate(layoutPageTemplateEntry.getGroupId(), name);
        }
        layoutPageTemplateEntry.setModifiedDate(new Date());
        layoutPageTemplateEntry.setName(name);
        layoutPageTemplateEntry = (LayoutPageTemplateEntry)this.layoutPageTemplateEntryPersistence.update((BaseModel)layoutPageTemplateEntry);
        this._fragmentEntryLinkLocalService.updateFragmentEntryLinks(serviceContext.getUserId(), layoutPageTemplateEntry.getGroupId(), this.classNameLocalService.getClassNameId(Layout.class.getName()), layoutPageTemplateEntry.getPlid(), fragmentEntryIds, editableValues, serviceContext);
        return layoutPageTemplateEntry;
    }

    public LayoutPageTemplateEntry updateStatus(long userId, long layoutPageTemplateEntryId, int status) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        LayoutPageTemplateEntry layoutPageTemplateEntry = this.layoutPageTemplateEntryPersistence.findByPrimaryKey(layoutPageTemplateEntryId);
        layoutPageTemplateEntry.setModifiedDate(new Date());
        layoutPageTemplateEntry.setStatus(status);
        layoutPageTemplateEntry.setStatusByUserId(userId);
        layoutPageTemplateEntry.setStatusByUserName(user.getScreenName());
        layoutPageTemplateEntry.setStatusDate(new Date());
        return this.layoutPageTemplateEntryLocalService.updateLayoutPageTemplateEntry(layoutPageTemplateEntry);
    }

    protected LayoutPageTemplateEntry addLayoutPageTemplateEntry(long groupId, LayoutPrototype layoutPrototype) throws PortalException {
        String nameXML = layoutPrototype.getName();
        Map nameMap = LocalizationUtil.getLocalizationMap((String)nameXML);
        Locale defaultLocale = LocaleUtil.fromLanguageId((String)LocalizationUtil.getDefaultLanguageId((String)nameXML));
        Layout layout = layoutPrototype.getLayout();
        int status = 0;
        if (!layoutPrototype.isActive()) {
            status = 5;
        }
        return this.addLayoutPageTemplateEntry(layoutPrototype.getUserId(), groupId, 0L, 0L, 0L, (String)nameMap.get(defaultLocale), 2, false, layoutPrototype.getLayoutPrototypeId(), 0L, layout.getPlid(), status, new ServiceContext());
    }

    protected void validate(long classNameId, long classTypeId, long groupId, Locale locale) throws PortalException {
        ClassName className = this._classNameLocalService.getClassName(classNameId);
        InfoDisplayContributor infoDisplayContributor = this._infoDisplayContributorTracker.getInfoDisplayContributor(className.getClassName());
        if (infoDisplayContributor == null) {
            throw new NoSuchClassNameException("Class name does not exist for class name ID " + classNameId);
        }
        List classTypes = infoDisplayContributor.getClassTypes(groupId, locale);
        if (!classTypes.isEmpty() && !ListUtil.exists((List)classTypes, classType -> classTypeId == classType.getClassTypeId())) {
            throw new NoSuchClassTypeException("Class type does not exist for class name ID " + classNameId);
        }
    }

    protected void validate(long groupId, String name) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new LayoutPageTemplateEntryNameException.MustNotBeNull(groupId);
        }
        LayoutPageTemplateEntryValidator.validateNameCharacters(name);
        int nameMaxLength = ModelHintsUtil.getMaxLength((String)LayoutPageTemplateEntry.class.getName(), (String)"name");
        if (name.length() > nameMaxLength) {
            throw new LayoutPageTemplateEntryNameException.MustNotExceedMaximumSize(nameMaxLength);
        }
        LayoutPageTemplateEntry layoutPageTemplateEntry = this.layoutPageTemplateEntryPersistence.fetchByG_N(groupId, name);
        if (layoutPageTemplateEntry != null) {
            throw new LayoutPageTemplateEntryNameException.MustNotBeDuplicate(groupId, name);
        }
    }

    private Layout _addLayout(long userId, long groupId, String name, int type, ServiceContext serviceContext) throws PortalException {
        boolean privateLayout = false;
        String layoutType = "asset_display";
        if (type == 0) {
            privateLayout = true;
            layoutType = "content";
        }
        Map<Locale, String> titleMap = Collections.singletonMap(LocaleUtil.getSiteDefault(), name);
        serviceContext.setAttribute("layout.instanceable.allowed", (Serializable)Boolean.TRUE);
        Layout layout = this.layoutLocalService.addLayout(userId, groupId, privateLayout, 0L, titleMap, titleMap, null, null, null, layoutType, "", true, true, new HashMap(), serviceContext);
        serviceContext.setModifiedDate(layout.getModifiedDate());
        this.layoutLocalService.addLayout(userId, groupId, privateLayout, layout.getParentLayoutId(), this.classNameLocalService.getClassNameId(Layout.class), layout.getPlid(), layout.getNameMap(), titleMap, layout.getDescriptionMap(), layout.getKeywordsMap(), layout.getRobotsMap(), layoutType, "", true, true, Collections.emptyMap(), serviceContext);
        return layout;
    }
}

