/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.page.template.service.impl;

import com.liferay.layout.page.template.exception.DuplicateLayoutPageTemplateCollectionException;
import com.liferay.layout.page.template.exception.LayoutPageTemplateCollectionNameException;
import com.liferay.layout.page.template.model.LayoutPageTemplateCollection;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.layout.page.template.service.base.LayoutPageTemplateCollectionLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.layout.page.template.model.LayoutPageTemplateCollection"}, service={AopService.class})
public class LayoutPageTemplateCollectionLocalServiceImpl
extends LayoutPageTemplateCollectionLocalServiceBaseImpl {
    @Reference
    private LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;

    public LayoutPageTemplateCollection addLayoutPageTemplateCollection(long userId, long groupId, String name, String description, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        this.validate(groupId, name);
        long layoutPageTemplateId = this.counterLocalService.increment();
        LayoutPageTemplateCollection layoutPageTemplateCollection = this.layoutPageTemplateCollectionPersistence.create(layoutPageTemplateId);
        layoutPageTemplateCollection.setUuid(serviceContext.getUuid());
        layoutPageTemplateCollection.setGroupId(groupId);
        layoutPageTemplateCollection.setCompanyId(user.getCompanyId());
        layoutPageTemplateCollection.setUserId(user.getUserId());
        layoutPageTemplateCollection.setUserName(user.getFullName());
        layoutPageTemplateCollection.setCreateDate(serviceContext.getCreateDate(new Date()));
        layoutPageTemplateCollection.setModifiedDate(serviceContext.getModifiedDate(new Date()));
        layoutPageTemplateCollection.setName(name);
        layoutPageTemplateCollection.setDescription(description);
        layoutPageTemplateCollection = (LayoutPageTemplateCollection)this.layoutPageTemplateCollectionPersistence.update((BaseModel)layoutPageTemplateCollection);
        this.resourceLocalService.addModelResources((AuditedModel)layoutPageTemplateCollection, serviceContext);
        return layoutPageTemplateCollection;
    }

    @Override
    public LayoutPageTemplateCollection deleteLayoutPageTemplateCollection(LayoutPageTemplateCollection layoutPageTemplateCollection) throws PortalException {
        this.layoutPageTemplateCollectionPersistence.remove((BaseModel)layoutPageTemplateCollection);
        this.resourceLocalService.deleteResource(layoutPageTemplateCollection.getCompanyId(), LayoutPageTemplateCollection.class.getName(), 4, layoutPageTemplateCollection.getLayoutPageTemplateCollectionId());
        List layoutPageTemplateEntries = this._layoutPageTemplateEntryLocalService.getLayoutPageTemplateEntries(layoutPageTemplateCollection.getGroupId(), layoutPageTemplateCollection.getLayoutPageTemplateCollectionId());
        for (LayoutPageTemplateEntry layoutPageTemplateEntry : layoutPageTemplateEntries) {
            this._layoutPageTemplateEntryLocalService.deleteLayoutPageTemplateEntry(layoutPageTemplateEntry);
        }
        return layoutPageTemplateCollection;
    }

    @Override
    public LayoutPageTemplateCollection deleteLayoutPageTemplateCollection(long layoutPageTemplateCollectionId) throws PortalException {
        return this.deleteLayoutPageTemplateCollection(this.getLayoutPageTemplateCollection(layoutPageTemplateCollectionId));
    }

    @Override
    public LayoutPageTemplateCollection fetchLayoutPageTemplateCollection(long layoutPageTemplateCollectionId) {
        return this.layoutPageTemplateCollectionPersistence.fetchByPrimaryKey(layoutPageTemplateCollectionId);
    }

    public List<LayoutPageTemplateCollection> getLayoutPageTemplateCollections(long groupId, int start, int end) {
        return this.layoutPageTemplateCollectionPersistence.findByGroupId(groupId, start, end);
    }

    public List<LayoutPageTemplateCollection> getLayoutPageTemplateCollections(long groupId, int start, int end, OrderByComparator<LayoutPageTemplateCollection> orderByComparator) {
        return this.layoutPageTemplateCollectionPersistence.findByGroupId(groupId, start, end, orderByComparator);
    }

    public List<LayoutPageTemplateCollection> getLayoutPageTemplateCollections(long groupId, String name, int start, int end, OrderByComparator<LayoutPageTemplateCollection> orderByComparator) {
        if (Validator.isNull((String)name)) {
            return this.layoutPageTemplateCollectionPersistence.findByGroupId(groupId, start, end, orderByComparator);
        }
        return this.layoutPageTemplateCollectionPersistence.findByG_LikeN(groupId, name, start, end, orderByComparator);
    }

    public LayoutPageTemplateCollection updateLayoutPageTemplateCollection(long layoutPageTemplateCollectionId, String name, String description) throws PortalException {
        LayoutPageTemplateCollection layoutPageTemplateCollection = this.layoutPageTemplateCollectionPersistence.findByPrimaryKey(layoutPageTemplateCollectionId);
        if (!Objects.equals(layoutPageTemplateCollection.getName(), name)) {
            this.validate(layoutPageTemplateCollection.getGroupId(), name);
        }
        layoutPageTemplateCollection.setModifiedDate(new Date());
        layoutPageTemplateCollection.setName(name);
        layoutPageTemplateCollection.setDescription(description);
        return (LayoutPageTemplateCollection)this.layoutPageTemplateCollectionPersistence.update((BaseModel)layoutPageTemplateCollection);
    }

    protected void validate(long groupId, String name) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new LayoutPageTemplateCollectionNameException("Name must not be null for group " + groupId);
        }
        int nameMaxLength = ModelHintsUtil.getMaxLength((String)LayoutPageTemplateEntry.class.getName(), (String)"name");
        if (name.length() > nameMaxLength) {
            throw new LayoutPageTemplateCollectionNameException("Maximum length of name exceeded");
        }
        LayoutPageTemplateCollection layoutPageTemplateCollection = this.layoutPageTemplateCollectionPersistence.fetchByG_N(groupId, name);
        if (layoutPageTemplateCollection != null) {
            throw new DuplicateLayoutPageTemplateCollectionException(name);
        }
    }
}

