/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.page.template.service.impl;

import com.liferay.asset.display.page.service.AssetDisplayPageEntryLocalService;
import com.liferay.dynamic.data.mapping.model.DDMStructureLink;
import com.liferay.dynamic.data.mapping.service.DDMStructureLinkLocalService;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.layout.page.template.exception.DuplicateLayoutPageTemplateEntryException;
import com.liferay.layout.page.template.exception.LayoutPageTemplateEntryNameException;
import com.liferay.layout.page.template.exception.RequiredLayoutPageTemplateEntryException;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.base.LayoutPageTemplateEntryLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class LayoutPageTemplateEntryLocalServiceImpl
extends LayoutPageTemplateEntryLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(LayoutPageTemplateEntryLocalServiceImpl.class);
    @ServiceReference(type=AssetDisplayPageEntryLocalService.class)
    private AssetDisplayPageEntryLocalService _assetDisplayPageEntryLocalService;
    @ServiceReference(type=CompanyLocalService.class)
    private CompanyLocalService _companyLocalService;
    @ServiceReference(type=DDMStructureLinkLocalService.class)
    private DDMStructureLinkLocalService _ddmStructureLinkLocalService;
    @ServiceReference(type=FragmentEntryLinkLocalService.class)
    private FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;

    public LayoutPageTemplateEntry addLayoutPageTemplateEntry(LayoutPrototype layoutPrototype) throws PortalException {
        Company company = this._companyLocalService.getCompany(layoutPrototype.getCompanyId());
        String nameXML = layoutPrototype.getName();
        Map nameMap = LocalizationUtil.getLocalizationMap((String)nameXML);
        Locale defaultLocale = LocaleUtil.fromLanguageId((String)LocalizationUtil.getDefaultLanguageId((String)nameXML));
        int status = 0;
        if (!layoutPrototype.isActive()) {
            status = 5;
        }
        return this.addLayoutPageTemplateEntry(layoutPrototype.getUserId(), company.getGroupId(), 0L, (String)nameMap.get(defaultLocale), 2, layoutPrototype.getLayoutPrototypeId(), status, new ServiceContext());
    }

    public LayoutPageTemplateEntry addLayoutPageTemplateEntry(long userId, long groupId, long layoutPageTemplateCollectionId, long classNameId, long classTypeId, String name, int type, boolean defaultTemplate, long layoutPrototypeId, long previewFileEntryId, int status, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        this.validate(groupId, name);
        long layoutPageTemplateEntryId = this.counterLocalService.increment();
        LayoutPageTemplateEntry layoutPageTemplateEntry = this.layoutPageTemplateEntryPersistence.create(layoutPageTemplateEntryId);
        layoutPageTemplateEntry.setUuid(serviceContext.getUuid());
        layoutPageTemplateEntry.setGroupId(groupId);
        layoutPageTemplateEntry.setCompanyId(user.getCompanyId());
        layoutPageTemplateEntry.setUserId(user.getUserId());
        layoutPageTemplateEntry.setUserName(user.getFullName());
        layoutPageTemplateEntry.setCreateDate(serviceContext.getCreateDate(new Date()));
        layoutPageTemplateEntry.setModifiedDate(serviceContext.getModifiedDate(new Date()));
        layoutPageTemplateEntry.setLayoutPageTemplateCollectionId(layoutPageTemplateCollectionId);
        layoutPageTemplateEntry.setClassNameId(classNameId);
        layoutPageTemplateEntry.setClassTypeId(classTypeId);
        layoutPageTemplateEntry.setName(name);
        layoutPageTemplateEntry.setType(type);
        layoutPageTemplateEntry.setPreviewFileEntryId(previewFileEntryId);
        layoutPageTemplateEntry.setDefaultTemplate(defaultTemplate);
        layoutPageTemplateEntry.setLayoutPrototypeId(layoutPrototypeId);
        layoutPageTemplateEntry.setStatus(status);
        layoutPageTemplateEntry.setStatusByUserId(userId);
        layoutPageTemplateEntry.setStatusByUserName(user.getFullName());
        layoutPageTemplateEntry.setStatusDate(new Date());
        this.layoutPageTemplateEntryPersistence.update((BaseModel)layoutPageTemplateEntry);
        this.resourceLocalService.addModelResources((AuditedModel)layoutPageTemplateEntry, serviceContext);
        return layoutPageTemplateEntry;
    }

    public LayoutPageTemplateEntry addLayoutPageTemplateEntry(long userId, long groupId, long layoutPageTemplateCollectionId, String name, int type, int status, ServiceContext serviceContext) throws PortalException {
        return this.addLayoutPageTemplateEntry(userId, groupId, layoutPageTemplateCollectionId, name, type, 0L, status, serviceContext);
    }

    public LayoutPageTemplateEntry addLayoutPageTemplateEntry(long userId, long groupId, long layoutPageTemplateCollectionId, String name, int type, long layoutPrototypeId, int status, ServiceContext serviceContext) throws PortalException {
        return this.addLayoutPageTemplateEntry(userId, groupId, layoutPageTemplateCollectionId, name, type, layoutPrototypeId, 0L, status, serviceContext);
    }

    public LayoutPageTemplateEntry addLayoutPageTemplateEntry(long userId, long groupId, long layoutPageTemplateCollectionId, String name, int type, long layoutPrototypeId, long previewFileEntryId, int status, ServiceContext serviceContext) throws PortalException {
        return this.addLayoutPageTemplateEntry(userId, groupId, layoutPageTemplateCollectionId, 0L, 0L, name, type, false, layoutPrototypeId, previewFileEntryId, status, serviceContext);
    }

    public LayoutPageTemplateEntry addLayoutPageTemplateEntry(long userId, long groupId, long layoutPageTemplateCollectionId, String name, int type, ServiceContext serviceContext) throws PortalException {
        return this.addLayoutPageTemplateEntry(userId, groupId, layoutPageTemplateCollectionId, name, type, 2, serviceContext);
    }

    public LayoutPageTemplateEntry addLayoutPageTemplateEntry(long userId, long groupId, long layoutPageTemplateCollectionId, String name, ServiceContext serviceContext) throws PortalException {
        return this.addLayoutPageTemplateEntry(userId, groupId, layoutPageTemplateCollectionId, name, 0, 2, serviceContext);
    }

    @Override
    public LayoutPageTemplateEntry deleteLayoutPageTemplateEntry(LayoutPageTemplateEntry layoutPageTemplateEntry) throws PortalException {
        int assetDisplayPageEntriesCount = this._assetDisplayPageEntryLocalService.getAssetDisplayPageEntriesCountByLayoutPageTemplateEntryId(layoutPageTemplateEntry.getLayoutPageTemplateEntryId());
        if (assetDisplayPageEntriesCount > 0) {
            throw new RequiredLayoutPageTemplateEntryException();
        }
        this.layoutPageTemplateEntryPersistence.remove((BaseModel)layoutPageTemplateEntry);
        this.resourceLocalService.deleteResource(layoutPageTemplateEntry.getCompanyId(), LayoutPageTemplateEntry.class.getName(), 4, layoutPageTemplateEntry.getLayoutPageTemplateEntryId());
        if (Objects.equals(layoutPageTemplateEntry.getType(), 1) && layoutPageTemplateEntry.getClassTypeId() > 0L) {
            DDMStructureLink ddmStructureLink = this._ddmStructureLinkLocalService.getUniqueStructureLink(this.classNameLocalService.getClassNameId(LayoutPageTemplateEntry.class), layoutPageTemplateEntry.getLayoutPageTemplateEntryId());
            this._ddmStructureLinkLocalService.deleteDDMStructureLink(ddmStructureLink);
        }
        this._fragmentEntryLinkLocalService.deleteLayoutPageTemplateEntryFragmentEntryLinks(layoutPageTemplateEntry.getGroupId(), this.classNameLocalService.getClassNameId(LayoutPageTemplateEntry.class.getName()), layoutPageTemplateEntry.getLayoutPageTemplateEntryId());
        return layoutPageTemplateEntry;
    }

    @Override
    public LayoutPageTemplateEntry deleteLayoutPageTemplateEntry(long layoutPageTemplateEntryId) throws PortalException {
        LayoutPageTemplateEntry layoutPageTemplateEntry = this.getLayoutPageTemplateEntry(layoutPageTemplateEntryId);
        return this.deleteLayoutPageTemplateEntry(layoutPageTemplateEntry);
    }

    public LayoutPageTemplateEntry fetchFirstLayoutPageTemplateEntry(long layoutPrototypeId) {
        return this.layoutPageTemplateEntryPersistence.fetchByLayoutPrototype_First(layoutPrototypeId, null);
    }

    @Override
    public LayoutPageTemplateEntry fetchLayoutPageTemplateEntry(long layoutPageTemplateEntryId) {
        return this.layoutPageTemplateEntryPersistence.fetchByPrimaryKey(layoutPageTemplateEntryId);
    }

    public List<LayoutPageTemplateEntry> getLayoutPageTemplateEntries(long groupId, long layoutPageTemplateCollectionId) {
        return this.getLayoutPageTemplateEntries(groupId, layoutPageTemplateCollectionId, -1);
    }

    public List<LayoutPageTemplateEntry> getLayoutPageTemplateEntries(long groupId, long layoutPageTemplateCollectionId, int status) {
        if (status == -1) {
            return this.layoutPageTemplateEntryPersistence.findByG_L(groupId, layoutPageTemplateCollectionId);
        }
        return this.layoutPageTemplateEntryPersistence.findByG_L_S(groupId, layoutPageTemplateCollectionId, status);
    }

    public List<LayoutPageTemplateEntry> getLayoutPageTemplateEntries(long groupId, long layoutPageTemplateCollectionId, int start, int end) {
        return this.getLayoutPageTemplateEntries(groupId, layoutPageTemplateCollectionId, -1, start, end);
    }

    public List<LayoutPageTemplateEntry> getLayoutPageTemplateEntries(long groupId, long layoutPageTemplateCollectionId, int status, int start, int end) {
        if (status == -1) {
            return this.layoutPageTemplateEntryPersistence.findByG_L(groupId, layoutPageTemplateCollectionId, start, end);
        }
        return this.layoutPageTemplateEntryPersistence.findByG_L_S(groupId, layoutPageTemplateCollectionId, status, start, end);
    }

    public List<LayoutPageTemplateEntry> getLayoutPageTemplateEntries(long groupId, long layoutPageTemplateCollectionId, int status, int start, int end, OrderByComparator<LayoutPageTemplateEntry> orderByComparator) {
        if (status == -1) {
            return this.layoutPageTemplateEntryPersistence.findByG_L(groupId, layoutPageTemplateCollectionId, start, end, orderByComparator);
        }
        return this.layoutPageTemplateEntryPersistence.findByG_L_S(groupId, layoutPageTemplateCollectionId, status, start, end, orderByComparator);
    }

    public List<LayoutPageTemplateEntry> getLayoutPageTemplateEntries(long groupId, long layoutPageTemplateCollectionId, int start, int end, OrderByComparator<LayoutPageTemplateEntry> orderByComparator) {
        return this.getLayoutPageTemplateEntries(groupId, layoutPageTemplateCollectionId, -1, start, end, orderByComparator);
    }

    public List<LayoutPageTemplateEntry> getLayoutPageTemplateEntries(long groupId, long layoutPageTemplateCollectionId, String name, int status, int start, int end, OrderByComparator<LayoutPageTemplateEntry> orderByComparator) {
        if (status == -1) {
            if (Validator.isNull((String)name)) {
                return this.layoutPageTemplateEntryPersistence.findByG_L(groupId, layoutPageTemplateCollectionId, start, end, orderByComparator);
            }
            return this.layoutPageTemplateEntryPersistence.findByG_L_LikeN(groupId, layoutPageTemplateCollectionId, name, start, end, orderByComparator);
        }
        if (Validator.isNull((String)name)) {
            return this.layoutPageTemplateEntryPersistence.findByG_L_S(groupId, layoutPageTemplateCollectionId, status, start, end, orderByComparator);
        }
        return this.layoutPageTemplateEntryPersistence.findByG_L_LikeN_S(groupId, layoutPageTemplateCollectionId, name, status, start, end, orderByComparator);
    }

    public List<LayoutPageTemplateEntry> getLayoutPageTemplateEntries(long groupId, long layoutPageTemplateCollectionId, String name, int start, int end, OrderByComparator<LayoutPageTemplateEntry> orderByComparator) {
        return this.getLayoutPageTemplateEntries(groupId, layoutPageTemplateCollectionId, name, -1, start, end, orderByComparator);
    }

    public LayoutPageTemplateEntry updateLayoutPageTemplateEntry(long layoutPageTemplateEntryId, boolean defaultTemplate) {
        LayoutPageTemplateEntry layoutPageTemplateEntry = this.fetchLayoutPageTemplateEntry(layoutPageTemplateEntryId);
        if (layoutPageTemplateEntry == null) {
            return null;
        }
        LayoutPageTemplateEntry defaultLayoutPageTemplateEntry = this.layoutPageTemplateEntryPersistence.fetchByG_C_C_D_First(layoutPageTemplateEntry.getGroupId(), layoutPageTemplateEntry.getClassNameId(), layoutPageTemplateEntry.getClassTypeId(), true, null);
        if (defaultTemplate && defaultLayoutPageTemplateEntry != null && defaultLayoutPageTemplateEntry.getLayoutPageTemplateEntryId() != layoutPageTemplateEntryId) {
            layoutPageTemplateEntry.setModifiedDate(new Date());
            defaultLayoutPageTemplateEntry.setDefaultTemplate(false);
            this.layoutPageTemplateEntryLocalService.updateLayoutPageTemplateEntry(defaultLayoutPageTemplateEntry);
        }
        layoutPageTemplateEntry.setModifiedDate(new Date());
        layoutPageTemplateEntry.setDefaultTemplate(defaultTemplate);
        this.layoutPageTemplateEntryLocalService.updateLayoutPageTemplateEntry(layoutPageTemplateEntry);
        return layoutPageTemplateEntry;
    }

    public LayoutPageTemplateEntry updateLayoutPageTemplateEntry(long layoutPageTemplateEntryId, long previewFileEntryId) throws PortalException {
        LayoutPageTemplateEntry layoutPageTemplateEntry = this.layoutPageTemplateEntryPersistence.findByPrimaryKey(layoutPageTemplateEntryId);
        layoutPageTemplateEntry.setModifiedDate(new Date());
        layoutPageTemplateEntry.setPreviewFileEntryId(previewFileEntryId);
        return this.layoutPageTemplateEntryLocalService.updateLayoutPageTemplateEntry(layoutPageTemplateEntry);
    }

    public LayoutPageTemplateEntry updateLayoutPageTemplateEntry(long userId, long layoutPageTemplateEntryId, int status) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        LayoutPageTemplateEntry layoutPageTemplateEntry = this.layoutPageTemplateEntryPersistence.findByPrimaryKey(layoutPageTemplateEntryId);
        layoutPageTemplateEntry.setModifiedDate(new Date());
        layoutPageTemplateEntry.setStatus(status);
        layoutPageTemplateEntry.setStatusByUserId(userId);
        layoutPageTemplateEntry.setStatusByUserName(user.getScreenName());
        layoutPageTemplateEntry.setStatusDate(new Date());
        return this.layoutPageTemplateEntryLocalService.updateLayoutPageTemplateEntry(layoutPageTemplateEntry);
    }

    public LayoutPageTemplateEntry updateLayoutPageTemplateEntry(long layoutPageTemplateEntryId, long classNameId, long classTypeId) throws PortalException {
        LayoutPageTemplateEntry layoutPageTemplateEntry = this.layoutPageTemplateEntryPersistence.findByPrimaryKey(layoutPageTemplateEntryId);
        layoutPageTemplateEntry.setModifiedDate(new Date());
        layoutPageTemplateEntry.setClassNameId(classNameId);
        layoutPageTemplateEntry.setClassTypeId(classTypeId);
        this.layoutPageTemplateEntryPersistence.update((BaseModel)layoutPageTemplateEntry);
        this._ddmStructureLinkLocalService.addStructureLink(this.classNameLocalService.getClassNameId(LayoutPageTemplateEntry.class), layoutPageTemplateEntryId, classTypeId);
        return layoutPageTemplateEntry;
    }

    public LayoutPageTemplateEntry updateLayoutPageTemplateEntry(long layoutPageTemplateEntryId, String name) throws PortalException {
        LayoutPageTemplateEntry layoutPageTemplateEntry = this.layoutPageTemplateEntryPersistence.findByPrimaryKey(layoutPageTemplateEntryId);
        if (Objects.equals(layoutPageTemplateEntry.getName(), name)) {
            return layoutPageTemplateEntry;
        }
        this.validate(layoutPageTemplateEntry.getGroupId(), name);
        layoutPageTemplateEntry.setModifiedDate(new Date());
        layoutPageTemplateEntry.setName(name);
        return this.layoutPageTemplateEntryLocalService.updateLayoutPageTemplateEntry(layoutPageTemplateEntry);
    }

    public LayoutPageTemplateEntry updateLayoutPageTemplateEntry(long layoutPageTemplateEntryId, String name, long[] fragmentEntryIds, String editableValues, ServiceContext serviceContext) throws PortalException {
        LayoutPageTemplateEntry layoutPageTemplateEntry = this.layoutPageTemplateEntryPersistence.findByPrimaryKey(layoutPageTemplateEntryId);
        if (!Objects.equals(layoutPageTemplateEntry.getName(), name)) {
            this.validate(layoutPageTemplateEntry.getGroupId(), name);
        }
        layoutPageTemplateEntry.setModifiedDate(new Date());
        layoutPageTemplateEntry.setName(name);
        this.layoutPageTemplateEntryPersistence.update((BaseModel)layoutPageTemplateEntry);
        this._fragmentEntryLinkLocalService.updateFragmentEntryLinks(serviceContext.getUserId(), layoutPageTemplateEntry.getGroupId(), this.classNameLocalService.getClassNameId(LayoutPageTemplateEntry.class.getName()), layoutPageTemplateEntryId, fragmentEntryIds, editableValues, serviceContext);
        return layoutPageTemplateEntry;
    }

    protected void validate(long groupId, String name) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new LayoutPageTemplateEntryNameException("Name must not be null for group " + groupId);
        }
        int nameMaxLength = ModelHintsUtil.getMaxLength((String)LayoutPageTemplateEntry.class.getName(), (String)"name");
        if (name.length() > nameMaxLength) {
            throw new LayoutPageTemplateEntryNameException("Maximum length of name exceeded");
        }
        LayoutPageTemplateEntry layoutPageTemplateEntry = this.layoutPageTemplateEntryPersistence.fetchByG_N(groupId, name);
        if (layoutPageTemplateEntry != null) {
            throw new DuplicateLayoutPageTemplateEntryException(name);
        }
    }
}

