/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.page.template.internal.upgrade.v1_1_0;

import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Locale;
import java.util.Map;

public class UpgradeLayoutPrototype
extends UpgradeProcess {
    private final CompanyLocalService _companyLocalService;
    private final LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;

    public UpgradeLayoutPrototype(CompanyLocalService companyLocalService, LayoutPageTemplateEntryLocalService layoutPageTemplateEntryLocalService) {
        this._companyLocalService = companyLocalService;
        this._layoutPageTemplateEntryLocalService = layoutPageTemplateEntryLocalService;
    }

    protected void doUpgrade() throws Exception {
        this.upgradeLayoutPrototype();
    }

    protected void upgradeLayoutPrototype() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps1 = this.connection.prepareStatement("select * from LayoutPrototype");
             ResultSet rs = ps1.executeQuery();){
            while (rs.next()) {
                long layoutPrototypeId = rs.getLong("layoutPrototypeId");
                long companyId = rs.getLong("companyId");
                long userId = rs.getLong("userId");
                String nameXML = rs.getString("name");
                LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryLocalService.fetchFirstLayoutPageTemplateEntry(layoutPrototypeId);
                if (layoutPageTemplateEntry != null) continue;
                Company company = this._companyLocalService.getCompany(companyId);
                Map nameMap = LocalizationUtil.getLocalizationMap((String)nameXML);
                Locale defaultLocale = LocaleUtil.fromLanguageId((String)LocalizationUtil.getDefaultLanguageId((String)nameXML));
                this._layoutPageTemplateEntryLocalService.addLayoutPageTemplateEntry(userId, company.getGroupId(), 0L, (String)nameMap.get(defaultLocale), 2, layoutPrototypeId, 0, new ServiceContext());
            }
        }
    }
}

