Liferay.Loader.define("layout-template-admin-web@1.0.39/js/modal/openDisplayPageModal.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/icon', 'frontend-js-react-web$react', 'frontend-js-react-web$react-dom', './DisplayPageModal.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = openDisplayPageModal;

    var _icon = require("@frontend-taglib-clay$clayui/icon");

    var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

    var _reactDom = _interopRequireDefault(require("frontend-js-react-web$react-dom"));

    var _DisplayPageModal = _interopRequireDefault(require("./DisplayPageModal.es"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    var container;
    /**
     * Opens a modal that will let the user choose the title
     * and the mapping types of a displaoy page.
     *
     * @param {string} param.displayPageName
     * @param {string} param.formSubmitURL
     * @param {array} param.mappingTypes
     * @param {string} param.namespace
     * @param {string} param.spritemap
     * @param {string} param.title
     */

    function openDisplayPageModal(_ref) {
      var displayPageName = _ref.displayPageName,
          formSubmitURL = _ref.formSubmitURL,
          mappingTypes = _ref.mappingTypes,
          namespace = _ref.namespace,
          spritemap = _ref.spritemap,
          title = _ref.title;

      if (container) {
        cleanUp();
      }

      container = document.createElement('div');
      document.body.appendChild(container); // eslint-disable-next-line liferay-portal/no-react-dom-render

      _reactDom["default"].render(_react["default"].createElement(_icon.ClayIconSpriteContext.Provider, {
        value: spritemap
      }, _react["default"].createElement(_DisplayPageModal["default"], {
        displayPageName: displayPageName,
        formSubmitURL: formSubmitURL,
        mappingTypes: mappingTypes,
        namespace: namespace,
        onClose: cleanUp,
        title: title
      })), container);

      Liferay.once('destroyPortlet', cleanUp);
    }

    function cleanUp() {
      if (container) {
        _reactDom["default"].unmountComponentAtNode(container);

        document.body.removeChild(container);
        container = null;
      }
    }
    //# sourceMappingURL=openDisplayPageModal.es.js.map
  }
});
//# sourceMappingURL=openDisplayPageModal.es.js.map