/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.util;

import com.liferay.layout.exception.LayoutConvertException;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructure;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureLocalService;
import com.liferay.layout.util.BulkLayoutConverter;
import com.liferay.layout.util.LayoutCopyHelper;
import com.liferay.layout.util.template.LayoutConversionResult;
import com.liferay.layout.util.template.LayoutConverter;
import com.liferay.layout.util.template.LayoutConverterRegistry;
import com.liferay.layout.util.template.LayoutData;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.PortletDecorator;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.PortletPreferencesLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.portlet.ReadOnlyException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={BulkLayoutConverter.class})
public class BulkLayoutConverterImpl
implements BulkLayoutConverter {
    private static final Log _log = LogFactoryUtil.getLog(BulkLayoutConverterImpl.class);
    private static final TransactionConfig _transactionConfig = TransactionConfig.Factory.create((Propagation)Propagation.REQUIRED, (Class[])new Class[]{Exception.class}, (Class[])new Class[0]);
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private LayoutConverterRegistry _layoutConverterRegistry;
    @Reference
    private LayoutCopyHelper _layoutCopyHelper;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateStructureLocalService _layoutPageTemplateStructureLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private PortletPreferencesLocalService _portletPreferencesLocalService;

    public void convertLayout(long plid) throws PortalException {
        this._convertLayout(plid);
    }

    public long[] convertLayouts(long groupId) throws PortalException {
        return this.convertLayouts(this.getConvertibleLayoutPlids(groupId));
    }

    public long[] convertLayouts(long[] plids) {
        ArrayList<Long> convertedLayoutPlids = new ArrayList<Long>();
        for (long plid : plids) {
            try {
                ConvertLayoutCallable callable = new ConvertLayoutCallable(plid);
                Layout layout = (Layout)TransactionInvokerUtil.invoke((TransactionConfig)_transactionConfig, (Callable)callable);
                convertedLayoutPlids.add(layout.getPlid());
            }
            catch (Throwable throwable) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)String.format("Layout with PLID %s cannot be converted", plid), throwable);
            }
        }
        return ArrayUtil.toLongArray(convertedLayoutPlids);
    }

    public Layout generatePreviewLayout(long plid) throws Exception {
        LayoutConversionResult layoutConversionResult = this.generatePreviewLayout(plid, LocaleUtil.getSiteDefault());
        return layoutConversionResult.getDraftLayout();
    }

    public LayoutConversionResult generatePreviewLayout(long plid, Locale locale) throws Exception {
        Layout layout = this._layoutLocalService.getLayout(plid);
        if (!Objects.equals(layout.getType(), "portlet")) {
            throw new LayoutConvertException("Layout with PLID " + layout.getPlid() + " is not convertible");
        }
        ServiceContext serviceContext = Optional.ofNullable(ServiceContextThreadLocal.getServiceContext()).orElse(new ServiceContext());
        Layout draftLayout = this._getOrCreateDraftLayout(layout, serviceContext);
        LayoutConversionResult layoutConversionResult = this._getLayoutConversionResult(draftLayout, locale);
        this._addOrUpdateLayoutPageTemplateStructure(draftLayout, layoutConversionResult.getLayoutData(), serviceContext);
        draftLayout = this._layoutLocalService.fetchLayout(draftLayout.getPlid());
        draftLayout.setType("content");
        draftLayout = this._layoutLocalService.updateLayout(draftLayout);
        this._updatePortletDecorator(draftLayout);
        return LayoutConversionResult.of(null, (String[])layoutConversionResult.getConversionWarningMessages(), (Layout)draftLayout);
    }

    public long[] getConvertibleLayoutPlids(long groupId) throws PortalException {
        ArrayList convertibleLayoutPlids = new ArrayList();
        ActionableDynamicQuery actionableDynamicQuery = this._layoutLocalService.getActionableDynamicQuery();
        if (groupId > 0L) {
            actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
                dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"groupId", (Object)groupId));
                dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"type", (Object)"portlet"));
                Property property = PropertyFactoryUtil.forName((String)"system");
                dynamicQuery.add(property.eq((Object)false));
            });
            actionableDynamicQuery.setPerformActionMethod(layout -> {
                LayoutConverter layoutConverter;
                UnicodeProperties typeSettingsUnicodeProperties = layout.getTypeSettingsProperties();
                String layoutTemplateId = typeSettingsUnicodeProperties.getProperty("layout-template-id");
                if (layoutTemplateId != null && (layoutConverter = this._layoutConverterRegistry.getLayoutConverter(layoutTemplateId)) != null && layoutConverter.isConvertible(layout)) {
                    convertibleLayoutPlids.add(layout.getPlid());
                }
            });
        }
        actionableDynamicQuery.performActions();
        return ArrayUtil.toLongArray(convertibleLayoutPlids);
    }

    private LayoutPageTemplateStructure _addOrUpdateLayoutPageTemplateStructure(Layout layout, LayoutData layoutData, ServiceContext serviceContext) throws PortalException {
        JSONObject layoutDataJSONObject = layoutData.getLayoutDataJSONObject();
        LayoutPageTemplateStructure layoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(layout.getGroupId(), this._portal.getClassNameId(Layout.class), layout.getPlid());
        if (layoutPageTemplateStructure == null) {
            return this._layoutPageTemplateStructureLocalService.addLayoutPageTemplateStructure(serviceContext.getUserId(), layout.getGroupId(), this._portal.getClassNameId(Layout.class), layout.getPlid(), layoutDataJSONObject.toString(), serviceContext);
        }
        return this._layoutPageTemplateStructureLocalService.updateLayoutPageTemplateStructure(layout.getGroupId(), this._portal.getClassNameId(Layout.class), layout.getPlid(), layoutDataJSONObject.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Layout _convertLayout(long plid) throws PortalException {
        Layout layout = this._layoutLocalService.getLayout(plid);
        if (!Objects.equals(layout.getType(), "portlet")) {
            throw new LayoutConvertException("Layout with PLID " + layout.getPlid() + " is not convertible");
        }
        ServiceContext serviceContext = Optional.ofNullable(ServiceContextThreadLocal.getServiceContext()).orElse(new ServiceContext());
        serviceContext.setScopeGroupId(layout.getGroupId());
        serviceContext.setUserId(layout.getUserId());
        try {
            ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
            this._updatePortletDecorator(layout);
            LayoutConversionResult layoutConversionResult = this._getLayoutConversionResult(layout, LocaleUtil.getSiteDefault());
            this._addOrUpdateLayoutPageTemplateStructure(layout, layoutConversionResult.getLayoutData(), serviceContext);
            layout = this._layoutLocalService.updateType(plid, "content");
            this._getOrCreateDraftLayout(layout, serviceContext);
            Layout layout2 = this._layoutLocalService.updateLayout(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), new Date());
            return layout2;
        }
        finally {
            ServiceContextThreadLocal.popServiceContext();
        }
    }

    private String _getDefaultPortletDecoratorId(Layout layout) throws PortalException {
        Theme theme = layout.getTheme();
        List portletDecorators = theme.getPortletDecorators();
        Stream portletDecoratorsStream = portletDecorators.stream();
        List filteredPortletDecorators = portletDecoratorsStream.filter(PortletDecorator::isDefaultPortletDecorator).collect(Collectors.toList());
        if (ListUtil.isEmpty(filteredPortletDecorators)) {
            return "";
        }
        PortletDecorator defaultPortletDecorator = (PortletDecorator)filteredPortletDecorators.get(0);
        return defaultPortletDecorator.getPortletDecoratorId();
    }

    private LayoutConversionResult _getLayoutConversionResult(Layout layout, Locale locale) throws LayoutConvertException {
        UnicodeProperties typeSettingsUnicodeProperties = layout.getTypeSettingsProperties();
        String layoutTemplateId = typeSettingsUnicodeProperties.getProperty("layout-template-id");
        if (Validator.isNull((String)layoutTemplateId)) {
            throw new LayoutConvertException("Layout template ID cannot be null");
        }
        LayoutConverter layoutConverter = this._layoutConverterRegistry.getLayoutConverter(layoutTemplateId);
        if (!layoutConverter.isConvertible(layout)) {
            throw new LayoutConvertException("Layout with PLID " + layout.getPlid() + " is not convertible");
        }
        return layoutConverter.convert(layout, locale);
    }

    private Layout _getOrCreateDraftLayout(Layout layout, ServiceContext serviceContext) throws PortalException {
        if (layout.getClassNameId() != 0L || layout.getClassPK() != 0L) {
            StringBundler sb = new StringBundler(3);
            sb.append("Layout with PLID ");
            sb.append(layout.getPlid());
            sb.append(" is a draft. You cannot get the draft of a draft.");
            throw new PortalException(sb.toString());
        }
        Layout draftLayout = layout.fetchDraftLayout();
        if (draftLayout == null) {
            draftLayout = this._layoutLocalService.addLayout(layout.getUserId(), layout.getGroupId(), layout.isPrivateLayout(), layout.getParentLayoutId(), this._classNameLocalService.getClassNameId(Layout.class), layout.getPlid(), layout.getNameMap(), layout.getTitleMap(), layout.getDescriptionMap(), layout.getKeywordsMap(), layout.getRobotsMap(), layout.getType(), layout.getTypeSettings(), true, true, Collections.emptyMap(), layout.getMasterLayoutPlid(), serviceContext);
        }
        try {
            return this._layoutCopyHelper.copyLayout(layout, draftLayout);
        }
        catch (Exception exception) {
            throw new PortalException((Throwable)exception);
        }
    }

    private void _updatePortletDecorator(Layout layout) throws PortalException {
        String defaultPortletDecoratorId = this._getDefaultPortletDecoratorId(layout);
        List portletPreferencesList = this._portletPreferencesLocalService.getPortletPreferences(0L, 3, layout.getPlid());
        for (PortletPreferences portletPreferences : portletPreferencesList) {
            javax.portlet.PortletPreferences jxPortletPreferences;
            String portletSetupPortletDecoratorId;
            String preferencesXML = portletPreferences.getPreferences();
            if (Validator.isNull((String)preferencesXML)) {
                preferencesXML = "<portlet-preferences />";
            }
            if (Validator.isNotNull((String)(portletSetupPortletDecoratorId = (jxPortletPreferences = PortletPreferencesFactoryUtil.fromDefaultXML((String)preferencesXML)).getValue("portletSetupPortletDecoratorId", "")))) continue;
            try {
                jxPortletPreferences.setValue("portletSetupPortletDecoratorId", defaultPortletDecoratorId);
            }
            catch (ReadOnlyException readOnlyException) {
                throw new PortalException((Throwable)readOnlyException);
            }
            portletPreferences.setPreferences(PortletPreferencesFactoryUtil.toXML((javax.portlet.PortletPreferences)jxPortletPreferences));
            this._portletPreferencesLocalService.updatePortletPreferences(portletPreferences);
        }
    }

    private class ConvertLayoutCallable
    implements Callable<Layout> {
        private final long _layoutPlid;

        @Override
        public Layout call() throws PortalException {
            return BulkLayoutConverterImpl.this._convertLayout(this._layoutPlid);
        }

        private ConvertLayoutCallable(Long layoutPlid) {
            this._layoutPlid = layoutPlid;
        }
    }
}

