/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.template.util;

import com.liferay.layout.internal.configuration.LayoutConverterConfiguration;
import com.liferay.layout.util.template.LayoutConversionResult;
import com.liferay.layout.util.template.LayoutConverter;
import com.liferay.layout.util.template.LayoutData;
import com.liferay.layout.util.template.LayoutTypeSettingsInspectorUtil;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTemplate;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;

@Component(configurationPid={"com.liferay.layout.internal.configuration.LayoutConverterConfiguration"}, immediate=true, property={"layout.template.id=default"}, service={LayoutConverter.class})
public class DefaultLayoutConverter
implements LayoutConverter {
    private static final String _CSS_CLASS_COLUMN_PREFIX = "col-md-";
    private volatile LayoutConverterConfiguration _layoutConverterConfiguration;

    public LayoutData convert(Layout layout) {
        LayoutConversionResult layoutConversionResult = this.convert(layout, LocaleUtil.getSiteDefault());
        return layoutConversionResult.getLayoutData();
    }

    public LayoutConversionResult convert(Layout layout, Locale locale) {
        String[] conversionWarningMessages = this._getConversionWarningMessages(layout, locale);
        if (!this._isLayoutTemplateParseable(layout)) {
            return LayoutConversionResult.of((LayoutData)LayoutData.of((Layout)layout, (UnsafeConsumer[])new UnsafeConsumer[]{layoutRow -> layoutRow.addLayoutColumns(new UnsafeConsumer[]{layoutColumn -> layoutColumn.addAllPortlets()})}), (String[])conversionWarningMessages);
        }
        ArrayList<UnsafeConsumer> rowUnsafeConsumers = new ArrayList<UnsafeConsumer>();
        Document layoutTemplateDocument = this._getLayoutTemplateDocument(layout);
        for (Element rowElement : layoutTemplateDocument.select(".portlet-layout.row")) {
            ArrayList<UnsafeConsumer> columnUnsafeConsumers = new ArrayList<UnsafeConsumer>();
            for (Element columnElement : rowElement.getElementsByClass("portlet-column")) {
                UnsafeConsumer columnUnsafeConsumer = layoutColumn -> {
                    layoutColumn.addPortlets(columnElement.id());
                    int columnSize = 12;
                    for (String className : columnElement.classNames()) {
                        if (!className.startsWith(_CSS_CLASS_COLUMN_PREFIX)) continue;
                        columnSize = GetterUtil.getInteger((String)className.substring(_CSS_CLASS_COLUMN_PREFIX.length()), (int)12);
                        break;
                    }
                    layoutColumn.setSize(columnSize);
                };
                columnUnsafeConsumers.add(columnUnsafeConsumer);
            }
            UnsafeConsumer rowUnsafeConsumer = layoutRow -> layoutRow.addLayoutColumns(columnUnsafeConsumers.toArray(new UnsafeConsumer[0]));
            rowUnsafeConsumers.add(rowUnsafeConsumer);
        }
        return LayoutConversionResult.of((LayoutData)LayoutData.of((Layout)layout, (UnsafeConsumer[])rowUnsafeConsumers.toArray(new UnsafeConsumer[0])), (String[])conversionWarningMessages);
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._layoutConverterConfiguration = (LayoutConverterConfiguration)ConfigurableUtil.createConfigurable(LayoutConverterConfiguration.class, properties);
    }

    private String[] _getConversionWarningMessages(Layout layout, Locale locale) {
        ArrayList<String> conversionWarningMessages = new ArrayList<String>();
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((Locale)locale, this.getClass());
        UnicodeProperties typeSettingsUnicodeProperties = layout.getTypeSettingsProperties();
        if (LayoutTypeSettingsInspectorUtil.hasNestedPortletsPortlet((UnicodeProperties)typeSettingsUnicodeProperties)) {
            conversionWarningMessages.add(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"this-page-uses-nested-applications-widgets.-they-have-been-placed-in-a-single-column-and-may-require-manual-reorganization"));
        }
        if (LayoutTypeSettingsInspectorUtil.isCustomizableLayout((UnicodeProperties)typeSettingsUnicodeProperties)) {
            conversionWarningMessages.add(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"this-page-has-customizable-columns.-this-capability-is-not-supported-for-content-pages-and-will-be-lost-if-the-conversion-draft-is-published"));
        }
        if (this._isLayoutTemplateParseable(layout) && !ArrayUtil.contains((Object[])this._layoutConverterConfiguration.verifiedLayoutTemplateIds(), (Object)typeSettingsUnicodeProperties.getProperty("layout-template-id"))) {
            conversionWarningMessages.add(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"this-page-uses-a-custom-page-layout.-a-best-effort-conversion-has-been-performed.-verify-the-conversion-draft-before-publishing-it"));
        }
        if (!this._isLayoutTemplateParseable(layout)) {
            conversionWarningMessages.add(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"this-page-uses-a-custom-page-layout.-all-widgets-have-been-placed-in-a-single-column-and-will-require-manual-reorganization"));
        }
        return conversionWarningMessages.toArray(new String[0]);
    }

    private Document _getLayoutTemplateDocument(Layout layout) {
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        LayoutTemplate layoutTemplate = layoutTypePortlet.getLayoutTemplate();
        Document document = Jsoup.parseBodyFragment((String)layoutTemplate.getContent());
        Document.OutputSettings outputSettings = new Document.OutputSettings();
        outputSettings.prettyPrint(false);
        document.outputSettings(outputSettings);
        return document;
    }

    private boolean _isLayoutTemplateParseable(Layout layout) {
        Document layoutTemplateDocument = this._getLayoutTemplateDocument(layout);
        Elements rowElements = layoutTemplateDocument.select(".portlet-layout.row");
        if (rowElements.isEmpty()) {
            return false;
        }
        for (Element rowElement : rowElements) {
            Elements columnElements = rowElement.getElementsByClass("portlet-column");
            if (columnElements.isEmpty()) {
                return false;
            }
            for (Element columnElement : columnElements) {
                int columnSize = 0;
                for (String className : columnElement.classNames()) {
                    if (!className.startsWith(_CSS_CLASS_COLUMN_PREFIX)) continue;
                    columnSize = GetterUtil.getInteger((String)className.substring(_CSS_CLASS_COLUMN_PREFIX.length()));
                    break;
                }
                if (columnSize != 0) continue;
                return false;
            }
        }
        return true;
    }
}

