/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.model.adapter;

import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.layout.set.model.adapter.StagedLayoutSet;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.model.LayoutSetWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.LayoutSetPrototypeLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.time.Instant;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;

public class StagedLayoutSetImpl
extends LayoutSetWrapper
implements StagedLayoutSet {
    private static final Log _log = LogFactoryUtil.getLog(StagedLayoutSetImpl.class);
    private Date _lastPublishDate;
    private LayoutSet _layoutSet;
    private String _layoutSetPrototypeName;
    private long _userId;
    private String _userName;
    private String _userUuid;

    public StagedLayoutSetImpl(LayoutSet layoutSet) {
        block3: {
            LayoutSetPrototype layoutSetPrototype;
            super(layoutSet);
            Objects.requireNonNull(layoutSet, "Unable to create a new staged layout set for a null layout set");
            this._layoutSet = layoutSet;
            UnicodeProperties settingsUnicodeProperties = this._layoutSet.getSettingsProperties();
            String lastPublishDateString = settingsUnicodeProperties.getProperty("last-publish-date");
            Instant instant = Instant.ofEpochMilli(GetterUtil.getLong((String)lastPublishDateString));
            this._lastPublishDate = Date.from(instant);
            if (Validator.isNotNull((String)this._layoutSet.getLayoutSetPrototypeUuid()) && (layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.fetchLayoutSetPrototypeByUuidAndCompanyId((String)this._layoutSet.getLayoutSetPrototypeUuid(), (long)this._layoutSet.getCompanyId())) != null) {
                this._layoutSetPrototypeName = layoutSetPrototype.getName(LocaleUtil.getDefault());
            }
            try {
                Group layoutSetGroup = this._layoutSet.getGroup();
                this._userId = layoutSetGroup.getCreatorUserId();
                User user = UserLocalServiceUtil.getUser((long)this._userId);
                this._userName = user.getFullName();
                this._userUuid = user.getUuid();
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Object)portalException, (Throwable)portalException);
            }
        }
    }

    public Object clone() {
        return new StagedLayoutSetImpl((LayoutSet)this._layoutSet.clone());
    }

    public long getGroupId() {
        return this._layoutSet.getGroupId();
    }

    public Date getLastPublishDate() {
        return this._lastPublishDate;
    }

    public LayoutSet getLayoutSet() {
        return this._layoutSet;
    }

    public Optional<String> getLayoutSetPrototypeName() {
        return Optional.ofNullable(this._layoutSetPrototypeName);
    }

    public Class<?> getModelClass() {
        return StagedLayoutSet.class;
    }

    public String getModelClassName() {
        return StagedLayoutSet.class.getName();
    }

    public Serializable getPrimaryKeyObj() {
        return this._layoutSet.getPrimaryKeyObj();
    }

    public StagedModelType getStagedModelType() {
        return new StagedModelType(StagedLayoutSet.class);
    }

    public long getUserId() {
        return this._userId;
    }

    public String getUserName() {
        return this._userName;
    }

    public String getUserUuid() {
        return this._userUuid;
    }

    public String getUuid() {
        return String.valueOf(this._layoutSet.isPrivateLayout());
    }

    @Deprecated
    public String getVirtualHostname() {
        return this._layoutSet.getVirtualHostname();
    }

    public void setLastPublishDate(Date lastPublishDate) {
        this._lastPublishDate = lastPublishDate;
        UnicodeProperties settingsUnicodeProperties = this.getSettingsProperties();
        settingsUnicodeProperties.setProperty("last-publish-date", String.valueOf(this._lastPublishDate.getTime()));
    }

    public void setLayoutSet(LayoutSet layoutSet) {
        this._layoutSet = layoutSet;
    }

    public void setLayoutSetPrototypeName(String layoutSetPrototypeName) {
        this._layoutSetPrototypeName = layoutSetPrototypeName;
    }

    public void setUserId(long userId) {
        this._userId = userId;
    }

    public void setUserName(String userName) {
        this._userName = userName;
    }

    public void setUserUuid(String userUuid) {
        this._userUuid = userUuid;
    }

    public void setUuid(String uuid) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setVirtualHostname(String virtualHostname) {
        this._layoutSet.setVirtualHostname(virtualHostname);
    }

    public void setVirtualHostnames(TreeMap virtualHostnames) {
        this._layoutSet.setVirtualHostnames(virtualHostnames);
    }
}

