/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.upgrade.v1_0_1;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;

public class UpgradeLayoutAsset
extends UpgradeProcess {
    private final AssetCategoryLocalService _assetCategoryLocalService;
    private final AssetEntryLocalService _assetEntryLocalService;
    private final AssetTagLocalService _assetTagLocalService;
    private final GroupLocalService _groupLocalService;
    private final LayoutLocalService _layoutLocalService;

    public UpgradeLayoutAsset(AssetCategoryLocalService assetCategoryLocalService, AssetEntryLocalService assetEntryLocalService, AssetTagLocalService assetTagLocalService, GroupLocalService groupLocalService, LayoutLocalService layoutLocalService) {
        this._assetCategoryLocalService = assetCategoryLocalService;
        this._assetEntryLocalService = assetEntryLocalService;
        this._assetTagLocalService = assetTagLocalService;
        this._groupLocalService = groupLocalService;
        this._layoutLocalService = layoutLocalService;
    }

    protected void doUpgrade() throws Exception {
        ActionableDynamicQuery actionableDynamicQuery = this._layoutLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property typeProperty = PropertyFactoryUtil.forName((String)"type");
            dynamicQuery.add(typeProperty.ne((Object)"asset_display"));
            dynamicQuery.add(typeProperty.ne((Object)"content"));
        });
        actionableDynamicQuery.setPerformActionMethod(layout -> this._updateAsset((Layout)layout));
        actionableDynamicQuery.performActions();
    }

    private void _updateAsset(Layout layout) throws PortalException {
        AssetEntry assetEntry = this._assetEntryLocalService.fetchEntry(Layout.class.getName(), layout.getPlid());
        if (assetEntry != null) {
            return;
        }
        Group group = this._groupLocalService.fetchGroup(layout.getGroupId());
        if (group == null) {
            return;
        }
        long[] assetCategoryIds = this._assetCategoryLocalService.getCategoryIds(Layout.class.getName(), layout.getPlid());
        String[] assetTagNames = this._assetTagLocalService.getTagNames(Layout.class.getName(), layout.getPlid());
        this._layoutLocalService.updateAsset(layout.getUserId(), layout, assetCategoryIds, assetTagNames);
    }
}

