/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.search.spi.model.index.contributor;

import com.liferay.layout.internal.search.util.LayoutCrawler;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructure;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureLocalService;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.util.Html;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import java.util.Locale;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"indexer.class.name=com.liferay.portal.kernel.model.Layout"}, service={ModelDocumentContributor.class})
public class LayoutModelDocumentContributor
implements ModelDocumentContributor<Layout> {
    public static final String CLASS_NAME = Layout.class.getName();
    @Reference
    private Html _html;
    @Reference
    private LayoutCrawler _layoutCrawler;
    @Reference
    private LayoutPageTemplateStructureLocalService _layoutPageTemplateStructureLocalService;
    @Reference
    private Portal _portal;

    public void contribute(Document document, Layout layout) {
        if (layout.isSystem()) {
            return;
        }
        document.addUID(CLASS_NAME, layout.getPlid());
        document.addText("defaultLanguageId", layout.getDefaultLanguageId());
        document.addLocalizedText("name", layout.getNameMap());
        document.addText("privateLayout", String.valueOf(layout.isPrivateLayout()));
        document.addText("type", layout.getType());
        LayoutPageTemplateStructure layoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(layout.getGroupId(), this._portal.getClassNameId(Layout.class), layout.getPlid());
        for (String languageId : layout.getAvailableLanguageIds()) {
            Locale locale = LocaleUtil.fromLanguageId((String)languageId);
            document.addText(Field.getLocalizedName((Locale)locale, (String)"title"), layout.getName(locale));
        }
        if (layoutPageTemplateStructure == null) {
            return;
        }
        Set locales = LanguageUtil.getAvailableLocales((long)layout.getGroupId());
        for (Locale locale : locales) {
            String content = this._html.stripHtml(this._layoutCrawler.getLayoutContent(layout, locale));
            if (Validator.isNull((String)content)) continue;
            document.addText(Field.getLocalizedName((Locale)locale, (String)"content"), content);
        }
    }
}

