/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.model.adapter;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.layout.set.model.adapter.StagedLayoutSet;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ColorScheme;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.model.LayoutSetVersion;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.version.VersionModel;
import com.liferay.portal.kernel.service.LayoutSetPrototypeLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;

public class StagedLayoutSetImpl
implements StagedLayoutSet {
    private static final Log _log = LogFactoryUtil.getLog(StagedLayoutSetImpl.class);
    private Date _lastPublishDate;
    private LayoutSet _layoutSet;
    private String _layoutSetPrototypeName;
    private long _userId;
    private String _userName;
    private String _userUuid;

    public StagedLayoutSetImpl() {
    }

    public StagedLayoutSetImpl(LayoutSet layoutSet) {
        block3: {
            LayoutSetPrototype layoutSetPrototype;
            Objects.requireNonNull(layoutSet, "Unable to create a new staged layout set for a null layout set");
            this._layoutSet = layoutSet;
            UnicodeProperties settingsProperties = this._layoutSet.getSettingsProperties();
            String lastPublishDateString = settingsProperties.getProperty("last-publish-date");
            Instant instant = Instant.ofEpochMilli(GetterUtil.getLong((String)lastPublishDateString));
            this._lastPublishDate = Date.from(instant);
            if (Validator.isNotNull((String)this._layoutSet.getLayoutSetPrototypeUuid()) && (layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.fetchLayoutSetPrototypeByUuidAndCompanyId((String)this._layoutSet.getLayoutSetPrototypeUuid(), (long)this._layoutSet.getCompanyId())) != null) {
                this._layoutSetPrototypeName = layoutSetPrototype.getName(LocaleUtil.getDefault());
            }
            try {
                Group layoutSetGroup = this._layoutSet.getGroup();
                this._userId = layoutSetGroup.getCreatorUserId();
                User user = UserLocalServiceUtil.getUser((long)this._userId);
                this._userName = user.getFullName();
                this._userUuid = user.getUuid();
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Object)portalException, (Throwable)portalException);
            }
        }
    }

    public Object clone() {
        return new StagedLayoutSetImpl((LayoutSet)this._layoutSet.clone());
    }

    public int compareTo(LayoutSet layoutSet) {
        return this._layoutSet.compareTo((Object)layoutSet);
    }

    public ColorScheme getColorScheme() {
        return this._layoutSet.getColorScheme();
    }

    public String getColorSchemeId() {
        return this._layoutSet.getColorSchemeId();
    }

    public String getCompanyFallbackVirtualHostname() {
        return this._layoutSet.getCompanyFallbackVirtualHostname();
    }

    public long getCompanyId() {
        return this._layoutSet.getCompanyId();
    }

    public Date getCreateDate() {
        return this._layoutSet.getCreateDate();
    }

    public String getCss() {
        return this._layoutSet.getCss();
    }

    public ExpandoBridge getExpandoBridge() {
        return this._layoutSet.getExpandoBridge();
    }

    public Group getGroup() throws PortalException {
        return this._layoutSet.getGroup();
    }

    public long getGroupId() {
        return this._layoutSet.getGroupId();
    }

    public long getHeadId() {
        return this._layoutSet.getHeadId();
    }

    public Date getLastPublishDate() {
        return this._lastPublishDate;
    }

    public long getLayoutSetId() {
        return this._layoutSet.getLayoutSetId();
    }

    public long getLayoutSetPrototypeId() throws PortalException {
        return this._layoutSet.getLayoutSetPrototypeId();
    }

    public boolean getLayoutSetPrototypeLinkEnabled() {
        return this._layoutSet.isLayoutSetPrototypeLinkEnabled();
    }

    public Optional<String> getLayoutSetPrototypeName() {
        return Optional.ofNullable(this._layoutSetPrototypeName);
    }

    public String getLayoutSetPrototypeUuid() {
        return this._layoutSet.getLayoutSetPrototypeUuid();
    }

    public long getLiveLogoId() {
        return this._layoutSet.getLiveLogoId();
    }

    public boolean getLogo() {
        return this._layoutSet.getLogo();
    }

    public long getLogoId() {
        return this._layoutSet.getLogoId();
    }

    public Map<String, Object> getModelAttributes() {
        return this._layoutSet.getModelAttributes();
    }

    public Class<?> getModelClass() {
        return this._layoutSet.getModelClass();
    }

    public String getModelClassName() {
        return this._layoutSet.getModelClassName();
    }

    public Date getModifiedDate() {
        return this._layoutSet.getModifiedDate();
    }

    public long getMvccVersion() {
        return this._layoutSet.getMvccVersion();
    }

    public int getPageCount() {
        return this._layoutSet.getPageCount();
    }

    public long getPrimaryKey() {
        return this._layoutSet.getPrimaryKey();
    }

    public Serializable getPrimaryKeyObj() {
        return this._layoutSet.getPrimaryKeyObj();
    }

    public boolean getPrivateLayout() {
        return this._layoutSet.isPrivateLayout();
    }

    public String getSettings() {
        return this._layoutSet.getSettings();
    }

    public UnicodeProperties getSettingsProperties() {
        return this._layoutSet.getSettingsProperties();
    }

    public String getSettingsProperty(String key) {
        return this._layoutSet.getSettingsProperty(key);
    }

    public StagedModelType getStagedModelType() {
        return new StagedModelType(StagedLayoutSet.class);
    }

    public Theme getTheme() {
        return this._layoutSet.getTheme();
    }

    public String getThemeId() {
        return this._layoutSet.getThemeId();
    }

    public String getThemeSetting(String key, String device) {
        return this._layoutSet.getThemeSetting(key, device);
    }

    public long getUserId() {
        return this._userId;
    }

    public String getUserName() {
        return this._userName;
    }

    public String getUserUuid() {
        return this._userUuid;
    }

    public String getUuid() {
        return String.valueOf(this._layoutSet.isPrivateLayout());
    }

    @Deprecated
    public String getVirtualHostname() {
        return this._layoutSet.getVirtualHostname();
    }

    public TreeMap<String, String> getVirtualHostnames() {
        return this._layoutSet.getVirtualHostnames();
    }

    public boolean hasSetModifiedDate() {
        return this._layoutSet.hasSetModifiedDate();
    }

    public boolean isCachedModel() {
        return this._layoutSet.isCachedModel();
    }

    public boolean isEntityCacheEnabled() {
        return this._layoutSet.isEntityCacheEnabled();
    }

    public boolean isEscapedModel() {
        return this._layoutSet.isEscapedModel();
    }

    public boolean isFinderCacheEnabled() {
        return this._layoutSet.isFinderCacheEnabled();
    }

    public boolean isLayoutSetPrototypeLinkActive() {
        return this._layoutSet.isLayoutSetPrototypeLinkActive();
    }

    public boolean isLayoutSetPrototypeLinkEnabled() {
        return this._layoutSet.isLayoutSetPrototypeLinkEnabled();
    }

    public boolean isLogo() {
        return this._layoutSet.isLogo();
    }

    public boolean isNew() {
        return this._layoutSet.isNew();
    }

    public boolean isPrivateLayout() {
        return this._layoutSet.isPrivateLayout();
    }

    public void persist() {
        this._layoutSet.persist();
    }

    public void populateVersionModel(LayoutSetVersion layoutSetVersion) {
        this._layoutSet.populateVersionModel((VersionModel)layoutSetVersion);
    }

    public void resetOriginalValues() {
        this._layoutSet.resetOriginalValues();
    }

    public void setCachedModel(boolean cachedModel) {
        this._layoutSet.setCachedModel(cachedModel);
    }

    public void setColorSchemeId(String colorSchemeId) {
        this._layoutSet.setColorSchemeId(colorSchemeId);
    }

    public void setCompanyFallbackVirtualHostname(String companyFallbackVirtualHostname) {
        this._layoutSet.setCompanyFallbackVirtualHostname(companyFallbackVirtualHostname);
    }

    public void setCompanyId(long companyId) {
        this._layoutSet.setCompanyId(companyId);
    }

    public void setCreateDate(Date createDate) {
        this._layoutSet.setCreateDate(createDate);
    }

    public void setCss(String css) {
        this._layoutSet.setCss(css);
    }

    public void setExpandoBridgeAttributes(BaseModel<?> baseModel) {
        this._layoutSet.setExpandoBridgeAttributes(baseModel);
    }

    public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge) {
        this._layoutSet.setExpandoBridgeAttributes(expandoBridge);
    }

    public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
        this._layoutSet.setExpandoBridgeAttributes(serviceContext);
    }

    public void setGroupId(long groupId) {
        this._layoutSet.setGroupId(groupId);
    }

    public void setHeadId(long headId) {
        this._layoutSet.setHeadId(headId);
    }

    public void setLastPublishDate(Date lastPublishDate) {
        this._lastPublishDate = lastPublishDate;
        UnicodeProperties settingsProperties = this.getSettingsProperties();
        settingsProperties.setProperty("last-publish-date", String.valueOf(this._lastPublishDate.getTime()));
    }

    public void setLayoutSet(LayoutSet layoutSet) {
        this._layoutSet = layoutSet;
    }

    public void setLayoutSetId(long layoutSetId) {
        this._layoutSet.setLayoutSetId(layoutSetId);
    }

    public void setLayoutSetPrototypeLinkEnabled(boolean layoutSetPrototypeLinkEnabled) {
        this._layoutSet.setLayoutSetPrototypeLinkEnabled(layoutSetPrototypeLinkEnabled);
    }

    public void setLayoutSetPrototypeName(String layoutSetPrototypeName) {
        this._layoutSetPrototypeName = layoutSetPrototypeName;
    }

    public void setLayoutSetPrototypeUuid(String layoutSetPrototypeUuid) {
        this._layoutSet.setLayoutSetPrototypeUuid(layoutSetPrototypeUuid);
    }

    public void setLogoId(long logoId) {
        this._layoutSet.setLogoId(logoId);
    }

    public void setModelAttributes(Map<String, Object> attributes) {
        this._layoutSet.setModelAttributes(attributes);
    }

    public void setModifiedDate(Date modifiedDate) {
        this._layoutSet.setModifiedDate(modifiedDate);
    }

    public void setMvccVersion(long mvccVersion) {
        this._layoutSet.setMvccVersion(mvccVersion);
    }

    public void setNew(boolean n) {
        this._layoutSet.setNew(n);
    }

    public void setPageCount(int pageCount) {
        this._layoutSet.setPageCount(pageCount);
    }

    public void setPrimaryKey(long primaryKey) {
        this._layoutSet.setPrimaryKey(primaryKey);
    }

    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        this._layoutSet.setPrimaryKeyObj(primaryKeyObj);
    }

    public void setPrivateLayout(boolean privateLayout) {
        this._layoutSet.setPrivateLayout(privateLayout);
    }

    public void setSettings(String settings) {
        this._layoutSet.setSettings(settings);
    }

    public void setSettingsProperties(UnicodeProperties settingsProperties) {
        this._layoutSet.setSettingsProperties(settingsProperties);
    }

    public void setThemeId(String themeId) {
        this._layoutSet.setThemeId(themeId);
    }

    public void setUserId(long userId) {
        this._userId = userId;
    }

    public void setUserName(String userName) {
        this._userName = userName;
    }

    public void setUserUuid(String userUuid) {
        this._userUuid = userUuid;
    }

    public void setUuid(String uuid) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setVirtualHostname(String virtualHostname) {
        this._layoutSet.setVirtualHostname(virtualHostname);
    }

    public void setVirtualHostnames(TreeMap virtualHostnames) {
        this._layoutSet.setVirtualHostnames(virtualHostnames);
    }

    public CacheModel<LayoutSet> toCacheModel() {
        return this._layoutSet.toCacheModel();
    }

    public LayoutSet toEscapedModel() {
        return (LayoutSet)this._layoutSet.toEscapedModel();
    }

    public LayoutSet toUnescapedModel() {
        return (LayoutSet)this._layoutSet.toUnescapedModel();
    }

    public String toXmlString() {
        return this._layoutSet.toXmlString();
    }
}

