/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.exportimport.data.handler;

import com.liferay.exportimport.content.processor.ExportImportContentProcessor;
import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportDateUtil;
import com.liferay.exportimport.kernel.lar.ExportImportHelper;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.ExportImportProcessCallbackRegistry;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.exportimport.kernel.staging.LayoutStagingUtil;
import com.liferay.exportimport.lar.ThemeExporter;
import com.liferay.exportimport.lar.ThemeImporter;
import com.liferay.layout.internal.exportimport.staged.model.repository.StagedLayoutSetStagedModelRepository;
import com.liferay.layout.set.model.adapter.StagedLayoutSet;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetBranch;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.model.adapter.ModelAdapterUtil;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ImageLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutSetBranchLocalService;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.service.LayoutSetPrototypeLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ColorSchemeFactoryUtil;
import com.liferay.portal.kernel.util.DateRange;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ThemeFactoryUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.service.impl.LayoutLocalServiceHelper;
import com.liferay.sites.kernel.util.SitesUtil;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class StagedLayoutSetStagedModelDataHandler
extends BaseStagedModelDataHandler<StagedLayoutSet> {
    public static final String[] CLASS_NAMES = new String[]{StagedLayoutSet.class.getName()};
    private static final Log _log = LogFactoryUtil.getLog(StagedLayoutSetStagedModelDataHandler.class);
    @Reference(target="(content.processor.type=DLReferences)")
    private ExportImportContentProcessor<String> _dlReferencesExportImportContentProcessor;
    @Reference
    private ExportImportHelper _exportImportHelper;
    @Reference
    private ExportImportProcessCallbackRegistry _exportImportProcessCallbackRegistry;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private ImageLocalService _imageLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutLocalServiceHelper _layoutLocalServiceHelper;
    @Reference
    private LayoutSetBranchLocalService _layoutSetBranchLocalService;
    @Reference
    private LayoutSetLocalService _layoutSetLocalService;
    @Reference
    private LayoutSetPrototypeLocalService _layoutSetPrototypeLocalService;
    @Reference
    private StagedLayoutSetStagedModelRepository _stagedLayoutSetStagedModelRepository;
    @Reference
    private ThemeExporter _themeExporter;
    @Reference
    private ThemeImporter _themeImporter;

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    protected void checkLayoutSetPrototypeLayouts(PortletDataContext portletDataContext, Set<Layout> modifiedLayouts) throws PortalException {
        boolean layoutSetPrototypeLinkEnabled = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"LAYOUT_SET_PROTOTYPE_LINK_ENABLED");
        if (!layoutSetPrototypeLinkEnabled || Validator.isNull((String)portletDataContext.getLayoutSetPrototypeUuid())) {
            return;
        }
        LayoutSetPrototype layoutSetPrototype = this._layoutSetPrototypeLocalService.getLayoutSetPrototypeByUuidAndCompanyId(portletDataContext.getLayoutSetPrototypeUuid(), portletDataContext.getCompanyId());
        List layoutSetLayouts = this._layoutLocalService.getLayouts(portletDataContext.getGroupId(), portletDataContext.isPrivateLayout());
        for (Layout layout : layoutSetLayouts) {
            if (Validator.isNull((String)layout.getSourcePrototypeLayoutUuid())) continue;
            if (SitesUtil.isLayoutModifiedSinceLastMerge((Layout)layout)) {
                modifiedLayouts.add(layout);
                continue;
            }
            Layout sourcePrototypeLayout = this._layoutLocalService.fetchLayout(layout.getSourcePrototypeLayoutUuid(), layoutSetPrototype.getGroupId(), true);
            if (sourcePrototypeLayout != null || !this._layoutLocalService.hasLayout(layout.getUuid(), layout.getGroupId(), layout.isPrivateLayout())) continue;
            this._layoutLocalService.deleteLayout(layout, false, ServiceContextThreadLocal.getServiceContext());
        }
    }

    protected void deleteMissingLayouts(PortletDataContext portletDataContext, List<Element> layoutElements) {
        boolean deleteMissingLayouts = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"DELETE_MISSING_LAYOUTS", (boolean)Boolean.TRUE);
        if (!deleteMissingLayouts) {
            return;
        }
        List previousLayouts = this._layoutLocalService.getLayouts(portletDataContext.getGroupId(), portletDataContext.isPrivateLayout());
        Stream layoutElementsStream = layoutElements.stream();
        List sourceLayoutUuids = layoutElementsStream.map(layoutElement -> layoutElement.attributeValue("uuid")).collect(Collectors.toList());
        if (_log.isDebugEnabled() && !sourceLayoutUuids.isEmpty()) {
            _log.debug((Object)"Delete missing layouts");
        }
        Map layoutPlids = portletDataContext.getNewPrimaryKeysMap(Layout.class);
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        for (Layout layout : previousLayouts) {
            if (sourceLayoutUuids.contains(layout.getUuid()) || layoutPlids.containsValue(layout.getPlid()) || (layout = this._layoutLocalService.fetchLayout(layout.getPlid())) == null) continue;
            String layoutUUID = layout.getUuid();
            long stagingGroupID = portletDataContext.getSourceGroupId();
            try {
                Layout stagedLayout = this._layoutLocalService.fetchLayoutByUuidAndGroupId(layoutUUID, stagingGroupID, !layout.isPublicLayout());
                if (stagedLayout != null && this._exportImportHelper.isLayoutRevisionInReview(stagedLayout)) continue;
                this._layoutLocalService.deleteLayout(layout, false, serviceContext);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to delete layout with UUID " + layoutUUID));
            }
        }
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, StagedLayoutSet stagedLayoutSet) throws Exception {
        boolean layoutSetSettings;
        this.exportLayouts(portletDataContext, stagedLayoutSet);
        this.exportLogo(portletDataContext, stagedLayoutSet);
        this.exportTheme(portletDataContext, stagedLayoutSet);
        boolean layoutSetPrototypeSettings = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"LAYOUT_SET_PROTOTYPE_SETTINGS");
        if (!layoutSetPrototypeSettings) {
            stagedLayoutSet.setLayoutSetPrototypeUuid("");
            stagedLayoutSet.setLayoutSetPrototypeLinkEnabled(false);
        }
        if (!(layoutSetSettings = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"LAYOUT_SET_SETTINGS"))) {
            stagedLayoutSet.setSettings("");
        }
        Element stagedLayoutSetElement = portletDataContext.getExportDataElement((ClassedModel)stagedLayoutSet);
        UnicodeProperties settingsProperties = stagedLayoutSet.getSettingsProperties();
        settingsProperties.remove((Object)"last-publish-date");
        stagedLayoutSet = this.unwrapLayoutSetStagingHandler(stagedLayoutSet);
        portletDataContext.addClassedModel(stagedLayoutSetElement, ExportImportPathUtil.getModelPath((StagedModel)stagedLayoutSet), (ClassedModel)stagedLayoutSet);
        boolean updateLastPublishDate = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"UPDATE_LAST_PUBLISH_DATE");
        if (ExportImportThreadLocal.isStagingInProcess() && updateLastPublishDate) {
            this._exportImportProcessCallbackRegistry.registerCallback(portletDataContext.getExportImportProcessId(), (Callable)new UpdateLayoutSetLastPublishDateCallable(portletDataContext.getDateRange(), portletDataContext.getGroupId(), portletDataContext.isPrivateLayout()));
        }
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, StagedLayoutSet stagedLayoutSet) throws Exception {
        Optional<StagedLayoutSet> existingLayoutSetOptional = this._stagedLayoutSetStagedModelRepository.fetchExistingLayoutSet(portletDataContext.getScopeGroupId(), stagedLayoutSet.isPrivateLayout());
        stagedLayoutSet.setPrivateLayout(portletDataContext.isPrivateLayout());
        StagedLayoutSet importedStagedLayoutSet = (StagedLayoutSet)stagedLayoutSet.clone();
        importedStagedLayoutSet.setGroupId(portletDataContext.getScopeGroupId());
        String layoutsImportMode = MapUtil.getString((Map)portletDataContext.getParameterMap(), (String)"LAYOUTS_IMPORT_MODE", (String)"MERGE_BY_LAYOUT_UUID");
        if (existingLayoutSetOptional.isPresent() && !layoutsImportMode.equals("CREATED_FROM_PROTOTYPE")) {
            StagedLayoutSet existingLayoutSet = existingLayoutSetOptional.get();
            importedStagedLayoutSet.setLayoutSetId(existingLayoutSet.getLayoutSetId());
            importedStagedLayoutSet = this._stagedLayoutSetStagedModelRepository.updateStagedModel(portletDataContext, importedStagedLayoutSet);
        }
        this.importLogo(portletDataContext);
        this.importTheme(portletDataContext, stagedLayoutSet);
        portletDataContext.importClassedModel((ClassedModel)stagedLayoutSet, (ClassedModel)importedStagedLayoutSet);
        Element layoutsElement = portletDataContext.getImportDataGroupElement(Layout.class);
        List layoutElements = layoutsElement.elements();
        this.deleteMissingLayouts(portletDataContext, layoutElements);
        HashSet<Layout> modifiedLayouts = new HashSet<Layout>();
        this.checkLayoutSetPrototypeLayouts(portletDataContext, modifiedLayouts);
        this.updateLayoutSetSettingsProperties(portletDataContext, importedStagedLayoutSet, "showSiteName", Boolean.TRUE.toString(), "lfr-theme:regular:show-footer", Boolean.TRUE.toString(), "lfr-theme:regular:show-header", Boolean.TRUE.toString(), "lfr-theme:regular:show-header-search", Boolean.TRUE.toString(), "lfr-theme:regular:show-maximize-minimize-application-links", Boolean.FALSE.toString(), "lfr-theme:regular:wrap-widget-page-content", Boolean.TRUE.toString(), "javascript", null);
        LayoutSet importedLayoutSet = (LayoutSet)importedStagedLayoutSet.toUnescapedModel();
        Group group = importedLayoutSet.getGroup();
        if (!group.isLayoutSetPrototype()) {
            this.updateLastMergeTime(portletDataContext, modifiedLayouts);
        }
        this.updateLayoutPriorities(portletDataContext, layoutElements, portletDataContext.isPrivateLayout());
        this._layoutSetLocalService.updatePageCount(portletDataContext.getGroupId(), portletDataContext.isPrivateLayout());
    }

    protected void exportLayouts(PortletDataContext portletDataContext, StagedLayoutSet stagedLayoutSet) throws Exception {
        portletDataContext.addDeletionSystemEventStagedModelTypes(new StagedModelType[]{new StagedModelType(Layout.class)});
        portletDataContext.getExportDataGroupElement(Layout.class);
        long[] layoutIds = portletDataContext.getLayoutIds();
        Group group = stagedLayoutSet.getGroup();
        if (group.isLayoutPrototype()) {
            layoutIds = this._exportImportHelper.getAllLayoutIds(group.getGroupId(), portletDataContext.isPrivateLayout());
        }
        List<StagedModel> stagedModels = this._stagedLayoutSetStagedModelRepository.fetchChildrenStagedModels(portletDataContext, stagedLayoutSet);
        for (StagedModel stagedModel : stagedModels) {
            Layout layout = (Layout)stagedModel;
            if (!ArrayUtil.contains((long[])layoutIds, (long)layout.getLayoutId())) {
                Element layoutElement = portletDataContext.getExportDataElement((ClassedModel)layout);
                layoutElement.addAttribute("action", "skip");
                layoutElement.addAttribute("layout-parent-layout-id", String.valueOf(layout.getParentLayoutId()));
                continue;
            }
            try {
                if (!LayoutStagingUtil.prepareLayoutStagingHandler((PortletDataContext)portletDataContext, (Layout)layout)) continue;
                StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)stagedLayoutSet, (StagedModel)layout, (String)"child");
            }
            catch (Exception exception) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Unable to export layout " + layout.getName()), (Throwable)exception);
                }
                throw exception;
            }
        }
    }

    protected void exportLogo(PortletDataContext portletDataContext, StagedLayoutSet stagedLayoutSet) {
        Image image;
        block8: {
            boolean logo = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"LOGO");
            if (!logo) {
                stagedLayoutSet.setLogoId(0L);
                return;
            }
            long layoutSetBranchId = MapUtil.getLong((Map)portletDataContext.getParameterMap(), (String)"layoutSetBranchId");
            LayoutSetBranch layoutSetBranch = this._layoutSetBranchLocalService.fetchLayoutSetBranch(layoutSetBranchId);
            image = null;
            if (layoutSetBranch != null) {
                try {
                    image = this._imageLocalService.getImage(layoutSetBranch.getLogoId());
                }
                catch (PortalException portalException) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("Unable to get logo for layout set branch " + layoutSetBranch.getLayoutSetBranchId()), (Throwable)portalException);
                    }
                    break block8;
                }
            }
            try {
                image = this._imageLocalService.getImage(stagedLayoutSet.getLogoId());
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) break block8;
                _log.warn((Object)("Unable to get logo for layout set " + stagedLayoutSet.getLayoutSetId()), (Throwable)portalException);
            }
        }
        if (image != null && image.getTextObj() != null) {
            String logoPath = ExportImportPathUtil.getModelPath((StagedModel)stagedLayoutSet, (String)(image.getImageId() + "." + image.getType()));
            Element rootElement = portletDataContext.getExportDataRootElement();
            Element headerElement = rootElement.element("header");
            headerElement.addAttribute("logo-path", logoPath);
            portletDataContext.addZipEntry(logoPath, image.getTextObj());
        }
    }

    protected void exportTheme(PortletDataContext portletDataContext, StagedLayoutSet stagedLayoutSet) throws Exception {
        block7: {
            boolean exportThemeSettings = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"THEME_REFERENCE");
            if (!exportThemeSettings) {
                stagedLayoutSet.setColorSchemeId(ColorSchemeFactoryUtil.getDefaultRegularColorSchemeId());
                stagedLayoutSet.setCss("");
                stagedLayoutSet.setThemeId(ThemeFactoryUtil.getDefaultRegularThemeId((long)stagedLayoutSet.getCompanyId()));
                return;
            }
            String css = (String)((Object)this._dlReferencesExportImportContentProcessor.replaceExportContentReferences(portletDataContext, (StagedModel)stagedLayoutSet, (Serializable)((Object)stagedLayoutSet.getCss()), true, false));
            stagedLayoutSet.setCss(css);
            long layoutSetBranchId = MapUtil.getLong((Map)portletDataContext.getParameterMap(), (String)"layoutSetBranchId");
            LayoutSetBranch layoutSetBranch = this._layoutSetBranchLocalService.fetchLayoutSetBranch(layoutSetBranchId);
            if (layoutSetBranch != null) {
                try {
                    this._themeExporter.exportTheme(portletDataContext, layoutSetBranch);
                }
                catch (Exception exception) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("Unable to export theme reference for layout set branch " + layoutSetBranch.getLayoutSetBranchId()), (Throwable)exception);
                    }
                    break block7;
                }
            }
            try {
                this._themeExporter.exportTheme(portletDataContext, (LayoutSet)stagedLayoutSet);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block7;
                _log.warn((Object)("Unable to export theme reference for layout set " + stagedLayoutSet.getLayoutSetId()), (Throwable)exception);
            }
        }
    }

    protected boolean hasSiblingLayoutWithSamePriority(Layout layout, List<Layout> siblingLayouts) {
        for (Layout siblingLayout : siblingLayouts) {
            if (layout.getPlid() == siblingLayout.getPlid() || layout.getPriority() != siblingLayout.getPriority()) continue;
            return true;
        }
        return false;
    }

    protected boolean hasSkippedSiblingLayout(Element layoutElement, Map<Long, List<String>> siblingActionsMap) {
        long parentLayoutId = GetterUtil.getLong((String)layoutElement.attributeValue("layout-parent-layout-id"));
        List<String> actions = siblingActionsMap.get(parentLayoutId);
        return actions.contains("skip");
    }

    protected void importLogo(PortletDataContext portletDataContext) {
        block5: {
            boolean logo = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"LOGO");
            if (!logo) {
                return;
            }
            Element rootElement = portletDataContext.getImportDataRootElement();
            Element headerElement = rootElement.element("header");
            String logoPath = headerElement.attributeValue("logo-path");
            byte[] iconBytes = portletDataContext.getZipEntryAsByteArray(logoPath);
            try {
                if (ArrayUtil.isNotEmpty((byte[])iconBytes)) {
                    this._layoutSetLocalService.updateLogo(portletDataContext.getGroupId(), portletDataContext.isPrivateLayout(), true, iconBytes);
                } else {
                    this._layoutSetLocalService.updateLogo(portletDataContext.getGroupId(), portletDataContext.isPrivateLayout(), false, (File)null);
                }
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) break block5;
                _log.warn((Object)"Unable to import logo", (Throwable)portalException);
            }
        }
    }

    protected void importTheme(PortletDataContext portletDataContext, StagedLayoutSet stagedLayoutSet) {
        block2: {
            try {
                String css = (String)((Object)this._dlReferencesExportImportContentProcessor.replaceImportContentReferences(portletDataContext, (StagedModel)stagedLayoutSet, (Serializable)((Object)stagedLayoutSet.getCss())));
                stagedLayoutSet.setCss(css);
                this._themeImporter.importTheme(portletDataContext, (LayoutSet)stagedLayoutSet);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)("Unable to import theme reference " + stagedLayoutSet.getThemeId()), (Throwable)exception);
            }
        }
    }

    protected StagedLayoutSet unwrapLayoutSetStagingHandler(StagedLayoutSet stagedLayoutSet) {
        LayoutSet layoutSet = (LayoutSet)ModelAdapterUtil.adapt((Object)stagedLayoutSet, StagedLayoutSet.class, LayoutSet.class);
        layoutSet = LayoutStagingUtil.mergeLayoutSetRevisionIntoLayoutSet((LayoutSet)layoutSet);
        return (StagedLayoutSet)ModelAdapterUtil.adapt((Object)layoutSet, LayoutSet.class, StagedLayoutSet.class);
    }

    protected void updateLastMergeTime(PortletDataContext portletDataContext, Set<Layout> modifiedLayouts) throws PortalException {
        String layoutsImportMode = MapUtil.getString((Map)portletDataContext.getParameterMap(), (String)"LAYOUTS_IMPORT_MODE", (String)"MERGE_BY_LAYOUT_UUID");
        if (!layoutsImportMode.equals("CREATED_FROM_PROTOTYPE")) {
            return;
        }
        Map layouts = portletDataContext.getNewPrimaryKeysMap(Layout.class + ".layout");
        long lastMergeTime = System.currentTimeMillis();
        for (Layout layout : layouts.values()) {
            if (modifiedLayouts.contains(layout = this._layoutLocalService.getLayout(layout.getPlid()))) continue;
            UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
            typeSettingsProperties.setProperty("last-merge-time", String.valueOf(lastMergeTime));
            this._layoutLocalService.updateLayout(layout);
        }
        LayoutSet layoutSet = this._layoutSetLocalService.getLayoutSet(portletDataContext.getGroupId(), portletDataContext.isPrivateLayout());
        UnicodeProperties settingsProperties = layoutSet.getSettingsProperties();
        settingsProperties.setProperty("last-merge-time", String.valueOf(lastMergeTime));
        long lastMergeVersion = MapUtil.getLong((Map)portletDataContext.getParameterMap(), (String)"lastMergeVersion");
        settingsProperties.setProperty("last-merge-version", String.valueOf(lastMergeVersion));
        this._layoutSetLocalService.updateLayoutSet(layoutSet);
    }

    protected void updateLayoutPriorities(PortletDataContext portletDataContext, List<Element> layoutElements, boolean privateLayout) throws PortalException {
        Layout layout;
        if (ExportImportThreadLocal.isInitialLayoutStagingInProcess()) {
            return;
        }
        Map layouts = portletDataContext.getNewPrimaryKeysMap(Layout.class + ".layout");
        HashMap<Long, Integer> layoutPriorities = new HashMap<Long, Integer>();
        HashMap<Long, List<String>> siblingActionsMap = new HashMap<Long, List<String>>();
        for (Element layoutElement : layoutElements) {
            long elementParentLayoutId = GetterUtil.getLong((String)layoutElement.attributeValue("layout-parent-layout-id"));
            ArrayList<String> actions = (ArrayList<String>)siblingActionsMap.get(elementParentLayoutId);
            if (actions == null) {
                actions = new ArrayList<String>();
            } else if (actions.contains("skip")) continue;
            actions.add(layoutElement.attributeValue("action"));
            siblingActionsMap.put(elementParentLayoutId, actions);
        }
        for (Element layoutElement : layoutElements) {
            long layoutId;
            String action = layoutElement.attributeValue("action");
            if (action.equals("skip") || this.hasSkippedSiblingLayout(layoutElement, siblingActionsMap) || !action.equals("add") || (layout = (Layout)layouts.get(layoutId = GetterUtil.getLong((String)layoutElement.attributeValue("layout-id")))) == null) continue;
            int layoutPriority = GetterUtil.getInteger((String)layoutElement.attributeValue("layout-priority"));
            layoutPriority = this._layoutLocalServiceHelper.getNextPriority(layout.getGroupId(), layout.isPrivateLayout(), layout.getParentLayoutId(), layout.getSourcePrototypeLayoutUuid(), layoutPriority);
            layoutPriorities.put(layout.getPlid(), layoutPriority);
        }
        HashSet<Long> parentLayoutIds = new HashSet<Long>();
        Set updatedPlids = layoutPriorities.keySet();
        Iterator<Object> iterator = updatedPlids.iterator();
        while (iterator.hasNext()) {
            long plid = (Long)iterator.next();
            layout = this._layoutLocalService.fetchLayout(plid);
            layout.setPriority(((Integer)layoutPriorities.get(plid)).intValue());
            this._layoutLocalService.updateLayout(layout);
            parentLayoutIds.add(layout.getParentLayoutId());
        }
        iterator = parentLayoutIds.iterator();
        while (iterator.hasNext()) {
            long parentLayoutId = (Long)iterator.next();
            List siblingLayouts = this._layoutLocalService.getLayouts(portletDataContext.getGroupId(), privateLayout, parentLayoutId);
            for (Layout layout2 : siblingLayouts) {
                if (updatedPlids.contains(layout2.getPlid()) || !this.hasSiblingLayoutWithSamePriority(layout2, siblingLayouts)) continue;
                do {
                    int priority = layout2.getPriority();
                    layout2.setPriority(++priority);
                } while (this.hasSiblingLayoutWithSamePriority(layout2, siblingLayouts));
                this._layoutLocalService.updateLayout(layout2);
            }
        }
    }

    protected void updateLayoutSetSettingsProperties(PortletDataContext portletDataContext, StagedLayoutSet importedLayoutSet, String ... defaultsArray) throws PortalException {
        LayoutSet layoutSet = this._layoutSetLocalService.getLayoutSet(portletDataContext.getGroupId(), portletDataContext.isPrivateLayout());
        UnicodeProperties settingsUnicodeProperties = layoutSet.getSettingsProperties();
        String mergeFailFriendlyURLLayouts = settingsUnicodeProperties.getProperty("merge-fail-friendly-url-layouts");
        if (Validator.isNull((String)mergeFailFriendlyURLLayouts)) {
            boolean changed = false;
            UnicodeProperties importedSettingsUnicodeProperties = importedLayoutSet.getSettingsProperties();
            Map defaultsMap = MapUtil.fromArray((Object[])defaultsArray);
            for (Map.Entry entry : defaultsMap.entrySet()) {
                String importedValue;
                String defaultValue;
                String propertyKey = (String)entry.getKey();
                String currentValue = settingsUnicodeProperties.getProperty(propertyKey, defaultValue = (String)entry.getValue());
                if (Objects.equals(currentValue, importedValue = importedSettingsUnicodeProperties.getProperty(propertyKey, defaultValue))) continue;
                settingsUnicodeProperties.setProperty(propertyKey, importedValue);
                changed = true;
            }
            if (changed) {
                this._layoutSetLocalService.updateLayoutSet(layoutSet);
            }
        }
    }

    private class UpdateLayoutSetLastPublishDateCallable
    implements Callable<Void> {
        private final DateRange _dateRange;
        private final long _groupId;
        private final boolean _privateLayout;

        public UpdateLayoutSetLastPublishDateCallable(DateRange dateRange, long groupId, boolean privateLayout) {
            this._dateRange = dateRange;
            this._groupId = groupId;
            this._privateLayout = privateLayout;
        }

        @Override
        public Void call() throws PortalException {
            Group group = StagedLayoutSetStagedModelDataHandler.this._groupLocalService.getGroup(this._groupId);
            Date endDate = null;
            if (this._dateRange != null) {
                endDate = this._dateRange.getEndDate();
            }
            if (group.hasStagingGroup()) {
                Group stagingGroup = group.getStagingGroup();
                ExportImportDateUtil.updateLastPublishDate((long)stagingGroup.getGroupId(), (boolean)this._privateLayout, (DateRange)this._dateRange, (Date)endDate);
            } else {
                ExportImportDateUtil.updateLastPublishDate((long)this._groupId, (boolean)this._privateLayout, (DateRange)this._dateRange, (Date)endDate);
            }
            return null;
        }
    }
}

