/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

import {LAYOUT_DATA_ITEM_TYPE_LABELS} from '../config/constants/layoutDataItemTypeLabels';
import {LAYOUT_DATA_ITEM_TYPES} from '../config/constants/layoutDataItemTypes';

export default function selectLayoutDataItemLabel(
	{fragmentEntryLinks},
	item,
	{useCustomName = true} = {}
) {
	if (useCustomName && item.config?.name) {
		return item.config.name;
	}

	if (
		item.type === LAYOUT_DATA_ITEM_TYPES.fragment &&
		fragmentEntryLinks[item.config?.fragmentEntryLinkId]?.name
	) {
		return fragmentEntryLinks[item.config.fragmentEntryLinkId].name;
	}

	return (
		LAYOUT_DATA_ITEM_TYPE_LABELS[item.type] ||
		item.type ||
		Liferay.Language.get('element')
	);
}
