Liferay.Loader.define("layout-content-page-editor-web@2.0.74/page_editor/plugins/page-structure/components/ItemConfiguration", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/alert', '@frontend-taglib-clay$clayui/tabs', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../../app/components/CollectionActiveItemContext', '../../../app/components/CollectionItemContext', '../../../app/components/Controls', '../../../app/store/index', '../../../app/utils/checkDeepEqual', '../../../app/utils/useId', '../selectors/selectPanels', './PageStructureSidebarSection'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = ItemConfiguration;

    var _alert = _interopRequireDefault(require("@frontend-taglib-clay$clayui/alert"));

    var _tabs = _interopRequireDefault(require("@frontend-taglib-clay$clayui/tabs"));

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _CollectionActiveItemContext = require("../../../app/components/CollectionActiveItemContext");

    var _CollectionItemContext = require("../../../app/components/CollectionItemContext");

    var _Controls = require("../../../app/components/Controls");

    var _index = require("../../../app/store/index");

    var _checkDeepEqual = require("../../../app/utils/checkDeepEqual");

    var _useId = require("../../../app/utils/useId");

    var _selectPanels = require("../selectors/selectPanels");

    var _PageStructureSidebarSection = _interopRequireDefault(require("./PageStructureSidebarSection"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    function _classCallCheck(instance, Constructor) {
      if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
      }
    }

    function _possibleConstructorReturn(self, call) {
      if (call && (_typeof(call) === "object" || typeof call === "function")) {
        return call;
      }return _assertThisInitialized(self);
    }

    function _assertThisInitialized(self) {
      if (self === void 0) {
        throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
      }return self;
    }

    function _getPrototypeOf(o) {
      _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
        return o.__proto__ || Object.getPrototypeOf(o);
      };return _getPrototypeOf(o);
    }

    function _defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
      }
    }

    function _createClass(Constructor, protoProps, staticProps) {
      if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
    }

    function _inherits(subClass, superClass) {
      if (typeof superClass !== "function" && superClass !== null) {
        throw new TypeError("Super expression must either be null or a function");
      }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
    }

    function _setPrototypeOf(o, p) {
      _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
        o.__proto__ = p;return o;
      };return _setPrototypeOf(o, p);
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    function ItemConfiguration() {
      var collectionContext = (0, _CollectionActiveItemContext.useCollectionActiveItemContext)();
      return _react["default"].createElement(_CollectionItemContext.CollectionItemContext.Provider, {
        value: collectionContext
      }, _react["default"].createElement(ItemConfigurationContent, null));
    }

    function ItemConfigurationContent() {
      var activeItemId = (0, _Controls.useActiveItemId)();
      var activeItemType = (0, _Controls.useActiveItemType)();

      var _useState = (0, _react.useState)(null),
          _useState2 = _slicedToArray(_useState, 2),
          activePanelId = _useState2[0],
          setActivePanelId = _useState2[1];

      var tabIdPrefix = (0, _useId.useId)();
      var panelIdPrefix = (0, _useId.useId)();

      var _useSelectorCallback = (0, _index.useSelectorCallback)(function (state) {
        return (0, _selectPanels.selectPanels)(activeItemId, activeItemType, state);
      }, [activeItemId, activeItemType], _checkDeepEqual.deepEqual),
          activeItem = _useSelectorCallback.activeItem,
          panelsIds = _useSelectorCallback.panelsIds;

      var panels = (0, _react.useMemo)(function () {
        return Object.entries(panelsIds).filter(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 2),
              show = _ref2[1];

          return show;
        }).map(function (_ref3) {
          var _ref4 = _slicedToArray(_ref3, 1),
              key = _ref4[0];

          return _objectSpread({}, _selectPanels.PANELS[key], {
            panelId: key
          });
        }).sort(function (panelA, panelB) {
          return panelB.priority - panelA.priority;
        });
      }, [panelsIds]);
      (0, _react.useEffect)(function () {
        setActivePanelId(function (panelId) {
          var _panels$0$panelId, _panels$;

          if (panels.find(function (panel) {
            return panel.panelId === panelId;
          })) {
            return panelId;
          }

          return (_panels$0$panelId = (_panels$ = panels[0]) === null || _panels$ === void 0 ? void 0 : _panels$.panelId) !== null && _panels$0$panelId !== void 0 ? _panels$0$panelId : '';
        });
      }, [panels]);

      if (!activeItem || !panels.length) {
        return _react["default"].createElement(_PageStructureSidebarSection["default"], {
          resizable: true,
          size: 0.6
        }, _react["default"].createElement("p", {
          className: "bg-light m-3 p-5 rounded small text-center text-secondary"
        }, Liferay.Language.get('select-an-element-of-the-page-to-show-this-panel')));
      }

      return _react["default"].createElement(_PageStructureSidebarSection["default"], {
        resizable: true,
        size: 1.5
      }, _react["default"].createElement("div", {
        className: "page-editor__page-structure__item-configuration"
      }, _react["default"].createElement(_tabs["default"], {
        className: "border-bottom pt-2 px-3",
        modern: true
      }, panels.map(function (panel) {
        return _react["default"].createElement(_tabs["default"].Item, {
          active: panel.panelId === activePanelId,
          innerProps: {
            'aria-controls': "".concat(panelIdPrefix, "-").concat(panel.panelId),
            id: "".concat(tabIdPrefix, "-").concat(panel.panelId)
          },
          key: panel.panelId,
          onClick: function onClick() {
            return setActivePanelId(panel.panelId);
          }
        }, _react["default"].createElement("span", {
          className: "c-inner page-editor__page-structure__item-configuration-tab",
          tabIndex: "-1"
        }, panel.label));
      })), _react["default"].createElement(_tabs["default"].Content, {
        activeIndex: panels.findIndex(function (panel) {
          return panel.panelId === activePanelId;
        })
      }, panels.map(function (panel) {
        return _react["default"].createElement(_tabs["default"].TabPane, {
          "aria-labelledby": "".concat(tabIdPrefix, "-").concat(panel.panelId),
          className: "p-3",
          id: "".concat(panelIdPrefix, "-").concat(panel.panelId),
          key: panel.panelId
        }, panel.panelId === activePanelId && _react["default"].createElement(ItemConfigurationComponent, {
          Component: panel.component,
          item: activeItem
        }));
      }))));
    }

    var ItemConfigurationComponent = /*#__PURE__*/function (_React$Component) {
      _inherits(ItemConfigurationComponent, _React$Component);

      _createClass(ItemConfigurationComponent, null, [{
        key: "getDerivedStateFromError",
        value: function getDerivedStateFromError(error) {
          return {
            error: error
          };
        }
      }]);

      function ItemConfigurationComponent(props) {
        var _this;

        _classCallCheck(this, ItemConfigurationComponent);

        _this = _possibleConstructorReturn(this, _getPrototypeOf(ItemConfigurationComponent).call(this, props));
        _this.state = {
          error: null
        };
        return _this;
      }

      _createClass(ItemConfigurationComponent, [{
        key: "render",
        value: function render() {
          var _this$props = this.props,
              Component = _this$props.Component,
              item = _this$props.item;
          return this.state.error ? _react["default"].createElement(_alert["default"], {
            displayType: "danger",
            title: Liferay.Language.get('error')
          }, Liferay.Language.get('an-unexpected-error-occurred-while-rendering-this-item')) : _react["default"].createElement(Component, {
            item: item,
            key: item.itemId
          });
        }
      }]);

      return ItemConfigurationComponent;
    }(_react["default"].Component);
    //# sourceMappingURL=ItemConfiguration.js.map
  }
});
//# sourceMappingURL=ItemConfiguration.js.map