Liferay.Loader.define("layout-content-page-editor-web@2.0.74/page_editor/plugins/experience/components/ExperienceItem", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/icon', '@frontend-taglib-clay$clayui/layout', '@frontend-taglib-clay$clayui/link', '@frontend-taglib-clay$clayui/list', '@frontend-taglib-clay$clayui/tooltip', 'frontend-js-react-web$classnames', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../statuses', '../types', './ExperimentLabel', './Popover'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = void 0;

    var _button = _interopRequireWildcard(require("@frontend-taglib-clay$clayui/button"));

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _layout = _interopRequireDefault(require("@frontend-taglib-clay$clayui/layout"));

    var _link = _interopRequireDefault(require("@frontend-taglib-clay$clayui/link"));

    var _list = _interopRequireDefault(require("@frontend-taglib-clay$clayui/list"));

    var _tooltip = require("@frontend-taglib-clay$clayui/tooltip");

    var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

    var _statuses = require("../statuses");

    var _types = require("../types");

    var _ExperimentLabel = _interopRequireDefault(require("./ExperimentLabel"));

    var _Popover = _interopRequireDefault(require("./Popover"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var ExperienceItem = function ExperienceItem(_ref) {
      var active = _ref.active,
          editable = _ref.editable,
          experience = _ref.experience,
          lockedDecreasePriority = _ref.lockedDecreasePriority,
          lockedIncreasePriority = _ref.lockedIncreasePriority,
          onDeleteExperience = _ref.onDeleteExperience,
          onEditExperience = _ref.onEditExperience,
          onPriorityDecrease = _ref.onPriorityDecrease,
          onPriorityIncrease = _ref.onPriorityIncrease,
          onSelect = _ref.onSelect;

      var itemClassName = (0, _classnames["default"])('d-flex dropdown-menu__experience', {
        'dropdown-menu__experience--active': active
      });
      return _react["default"].createElement(_list["default"].Item, {
        "aria-checked": active,
        className: itemClassName,
        role: "listitem"
      }, _react["default"].createElement(_list["default"].ItemField, {
        expand: true
      }, _react["default"].createElement(_button["default"], {
        displayType: "unstyled",
        onClick: function handleSelect() {
          return onSelect(experience.segmentsExperienceId);
        }
      }, _react["default"].createElement(_layout["default"].ContentRow, {
        verticalAlign: "center"
      }, _react["default"].createElement(_layout["default"].ContentCol, {
        style: {
          flexShrink: 1,
          minWidth: 0
        }
      }, _react["default"].createElement(_layout["default"].ContentSection, null, _react["default"].createElement("span", {
        className: "text-truncate-inline"
      }, _react["default"].createElement(_tooltip.ClayTooltipProvider, null, _react["default"].createElement("span", {
        className: "font-weight-semi-bold text-truncate",
        "data-tooltip-align": "top",
        title: experience.name
      }, experience.name)), experience.hasLockedSegmentsExperiment && _react["default"].createElement(ExperienceLockIcon, null)), _react["default"].createElement("span", {
        className: "text-truncate"
      }, _react["default"].createElement("span", {
        className: "mr-1 text-secondary"
      }, Liferay.Language.get('audience')), experience.segmentsEntryName), experience.segmentsExperimentStatus && _react["default"].createElement("div", null, _react["default"].createElement("span", {
        className: "font-weight-normal mr-1 text-secondary"
      }, Liferay.Language.get('ab-test')), _react["default"].createElement(_ExperimentLabel["default"], {
        label: experience.segmentsExperimentStatus.label,
        value: experience.segmentsExperimentStatus.value
      }))))))), _react["default"].createElement(_list["default"].ItemField, {
        className: "align-self-center"
      }, _react["default"].createElement(ExperienceActions, {
        editable: editable,
        experience: experience,
        handleExperienceDelete: function handleExperienceDelete() {
          var experienceHasRunningExperiment = experience.segmentsExperimentStatus && experience.segmentsExperimentStatus.value === _statuses.STATUS_DRAFT;
          var confirmationMessage = experienceHasRunningExperiment ? Liferay.Language.get('delete-experience-with-running-test-confirmation-message') : Liferay.Language.get('do-you-want-to-delete-this-experience');
          var confirmed = confirm(confirmationMessage);

          if (confirmed) {
            onDeleteExperience(experience.segmentsExperienceId);
          }
        },
        handleExperienceEdit: function handleExperienceEdit() {
          var name = experience.name,
              segmentsEntryId = experience.segmentsEntryId,
              segmentsExperienceId = experience.segmentsExperienceId;
          onEditExperience({
            name: name,
            segmentsEntryId: segmentsEntryId,
            segmentsExperienceId: segmentsExperienceId
          });
        },
        handleExperimentNavigation: function handleExperimentNavigation(event) {
          event.preventDefault();
          Liferay.Util.Session.set('com.liferay.segments.experiment.web_panelState', 'open').then(function () {
            Liferay.Util.navigate(experience.segmentsExperimentURL);
          });
        },
        handlePriorityDecrease: function handlePriorityDecrease() {
          return onPriorityDecrease(experience.segmentsExperienceId, experience.priority);
        },
        handlePriorityIncrease: function handlePriorityIncrease() {
          return onPriorityIncrease(experience.segmentsExperienceId, experience.priority);
        },
        lockedDecreasePriority: lockedDecreasePriority,
        lockedIncreasePriority: lockedIncreasePriority
      })));
    };

    var ExperienceActions = function ExperienceActions(_ref2) {
      var editable = _ref2.editable,
          experience = _ref2.experience,
          handleExperienceDelete = _ref2.handleExperienceDelete,
          handleExperienceEdit = _ref2.handleExperienceEdit,
          handleExperimentNavigation = _ref2.handleExperimentNavigation,
          handlePriorityDecrease = _ref2.handlePriorityDecrease,
          handlePriorityIncrease = _ref2.handlePriorityIncrease,
          lockedDecreasePriority = _ref2.lockedDecreasePriority,
          lockedIncreasePriority = _ref2.lockedIncreasePriority;
      return _react["default"].createElement(_react["default"].Fragment, null, editable && _react["default"].createElement("div", {
        className: "pl-2"
      }, _react["default"].createElement(_button.ClayButtonWithIcon, {
        "aria-label": Liferay.Language.get('prioritize-experience'),
        borderless: true,
        className: "component-action mx-1",
        disabled: lockedIncreasePriority,
        displayType: "unstyled",
        monospaced: true,
        onClick: handlePriorityIncrease,
        outline: true,
        symbol: "angle-up",
        title: Liferay.Language.get('prioritize-experience'),
        type: "button"
      }), _react["default"].createElement(_button.ClayButtonWithIcon, {
        "aria-label": Liferay.Language.get('deprioritize-experience'),
        borderless: true,
        className: "component-action mx-1",
        disabled: lockedDecreasePriority,
        displayType: "unstyled",
        monospaced: true,
        onClick: handlePriorityDecrease,
        outline: true,
        symbol: "angle-down",
        title: Liferay.Language.get('deprioritize-experience'),
        type: "button"
      }), _react["default"].createElement(_button.ClayButtonWithIcon, {
        "aria-label": Liferay.Language.get('edit-experience'),
        borderless: true,
        className: "component-action mx-1",
        displayType: "unstyled",
        monospaced: true,
        onClick: handleExperienceEdit,
        outline: true,
        symbol: "pencil",
        title: Liferay.Language.get('edit-experience'),
        type: "button"
      }), _react["default"].createElement(_button.ClayButtonWithIcon, {
        "aria-label": Liferay.Language.get('delete-experience'),
        borderless: true,
        className: "component-action mx-1",
        displayType: "unstyled",
        monospaced: true,
        onClick: handleExperienceDelete,
        outline: true,
        symbol: "times-circle",
        title: Liferay.Language.get('delete-experience'),
        type: "button"
      })), experience.hasLockedSegmentsExperiment && experience.segmentsExperimentURL && _react["default"].createElement("div", {
        className: "pl-2"
      }, _react["default"].createElement(_link["default"], {
        "aria-label": Liferay.Language.get('go-to-test-details'),
        borderless: true,
        className: "component-action mx-1",
        displayType: "unstyled",
        href: experience.segmentsExperimentURL,
        monospaced: true,
        onClick: handleExperimentNavigation,
        outline: true,
        title: Liferay.Language.get('go-to-test-details')
      }, _react["default"].createElement(_icon["default"], {
        symbol: "test"
      }))));
    };

    var ExperienceLockIcon = function ExperienceLockIcon() {
      var iconRef = _react["default"].useRef();

      var _React$useState = _react["default"].useState(false),
          _React$useState2 = _slicedToArray(_React$useState, 2),
          showtoolTip = _React$useState2[0],
          setShowtoolTip = _React$useState2[1];

      return _react["default"].createElement("span", null, _react["default"].createElement(_icon["default"], {
        className: "text-secondary",
        onMouseEnter: function onMouseEnter() {
          return setShowtoolTip(true);
        },
        onMouseLeave: function onMouseLeave() {
          return setShowtoolTip(false);
        },
        ref: iconRef,
        symbol: "lock"
      }), showtoolTip && _react["default"].createElement(_Popover["default"], {
        anchor: iconRef.current,
        header: Liferay.Language.get('experience-locked')
      }, Liferay.Language.get('edit-is-not-allowed-for-this-experience')));
    };

    var _default = ExperienceItem;
    exports["default"] = _default;
    //# sourceMappingURL=ExperienceItem.js.map
  }
});
//# sourceMappingURL=ExperienceItem.js.map