Liferay.Loader.define("layout-content-page-editor-web@2.0.74/page_editor/app/utils/dragAndDrop/checkAllowedChild", ['module', 'exports', 'require', '../../config/constants/layoutDataItemTypes'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = checkAllowedChild;

    var _layoutDataItemTypes = require("../../config/constants/layoutDataItemTypes");

    var _LAYOUT_DATA_ALLOWED_;

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    var LAYOUT_DATA_ALLOWED_CHILDREN_TYPES = (_LAYOUT_DATA_ALLOWED_ = {}, _defineProperty(_LAYOUT_DATA_ALLOWED_, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.root, [_layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.collection, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.dropZone, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.container, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.row, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.fragment]), _defineProperty(_LAYOUT_DATA_ALLOWED_, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.collection, []), _defineProperty(_LAYOUT_DATA_ALLOWED_, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.collectionItem, [_layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.container, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.row, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.fragment]), _defineProperty(_LAYOUT_DATA_ALLOWED_, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.dropZone, []), _defineProperty(_LAYOUT_DATA_ALLOWED_, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.container, [_layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.collection, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.container, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.dropZone, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.row, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.fragment]), _defineProperty(_LAYOUT_DATA_ALLOWED_, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.row, [_layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.column]), _defineProperty(_LAYOUT_DATA_ALLOWED_, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.column, [_layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.collection, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.container, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.dropZone, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.row, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.fragment]), _defineProperty(_LAYOUT_DATA_ALLOWED_, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.fragment, []), _defineProperty(_LAYOUT_DATA_ALLOWED_, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.fragmentDropZone, [_layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.collection, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.dropZone, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.container, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.row, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.fragment]), _LAYOUT_DATA_ALLOWED_);
    /**
     * Checks if the given child can be nested inside given parent
     * @param {object} child
     * @param {object} parent
     * @param {{current: object}} layoutDataRef
     * @return {boolean}
     */

    function checkAllowedChild(child, parent, layoutDataRef) {
      var parentIsInsideCollection = function checkItemInsideCollection(item) {
        if (item.type === _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.collection) {
          return true;
        } else if (item.parentId) {
          return checkItemInsideCollection(layoutDataRef.current.items[item.parentId]);
        }
      }(parent);

      if (parentIsInsideCollection && child.type === _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.collection) {
        return false;
      }

      return LAYOUT_DATA_ALLOWED_CHILDREN_TYPES[parent.type].includes(child.type);
    }
    //# sourceMappingURL=checkAllowedChild.js.map
  }
});
//# sourceMappingURL=checkAllowedChild.js.map