Liferay.Loader.define("layout-content-page-editor-web@2.0.74/page_editor/app/utils/canBeDuplicated", ['module', 'exports', 'require', '../components/layout-data-items/hasDropZoneChild', '../config/constants/layoutDataItemTypes'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = canBeDuplicated;

    var _hasDropZoneChild = _interopRequireDefault(require("../components/layout-data-items/hasDropZoneChild"));

    var _layoutDataItemTypes = require("../config/constants/layoutDataItemTypes");

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    function canBeDuplicated(fragmentEntryLinks, item, layoutData, widgets) {
      switch (item.type) {
        case _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.collection:
          return true;

        case _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.container:
        case _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.row:
          return !(0, _hasDropZoneChild["default"])(item, layoutData);

        case _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.fragment:
          {
            var fragmentEntryLink = fragmentEntryLinks[item.config.fragmentEntryLinkId];
            var portletId = fragmentEntryLink.editableValues.portletId;
            var widget = portletId && getWidget(widgets, portletId);
            return (!widget || widget.instanceable) && !(0, _hasDropZoneChild["default"])(item, layoutData);
          }

        default:
          return false;
      }
    }

    function getWidget(widgets, portletId) {
      var widget = null;

      for (var i = 0; i < widgets.length; i++) {
        var _widgets$i = widgets[i],
            _widgets$i$categories = _widgets$i.categories,
            categories = _widgets$i$categories === void 0 ? [] : _widgets$i$categories,
            _widgets$i$portlets = _widgets$i.portlets,
            portlets = _widgets$i$portlets === void 0 ? [] : _widgets$i$portlets;
        var categoryPortlet = portlets.find(function (portlet) {
          return portlet.portletId === portletId;
        });
        var subCategoryPortlet = getWidget(categories, portletId);
        widget = subCategoryPortlet || categoryPortlet;

        if (widget) {
          return widget;
        }
      }

      return widget;
    }
    //# sourceMappingURL=canBeDuplicated.js.map
  }
});
//# sourceMappingURL=canBeDuplicated.js.map