Liferay.Loader.define("layout-content-page-editor-web@2.0.74/page_editor/app/thunks/redo", ['module', 'exports', 'require', '../actions/types', '../components/undo/undoActions'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = redo;

    var _types = require("../actions/types");

    var _undoActions = require("../components/undo/undoActions");

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _toArray(arr) {
      return _arrayWithHoles(arr) || _iterableToArray(arr) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArray(iter) {
      if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var promise = Promise.resolve();

    function redo(_ref) {
      var store = _ref.store;
      return function (dispatch) {
        if (!store.redoHistory || store.redoHistory.length === 0) {
          return;
        }

        var _ref2 = store.redoHistory || [],
            _ref3 = _toArray(_ref2),
            lastRedo = _ref3[0],
            redos = _ref3.slice(1);

        dispatch({
          redoHistory: redos,
          type: _types.UPDATE_REDO_ACTIONS
        });

        var redoDispatch = function redoDispatch(action) {
          return dispatch(_objectSpread({}, action, {
            isRedo: true,
            originalType: lastRedo.originalType || lastRedo.type
          }));
        };

        promise = promise.then(function () {
          return (0, _undoActions.undoAction)({
            action: lastRedo,
            store: store
          })(redoDispatch);
        });
      };
    }
    //# sourceMappingURL=redo.js.map
  }
});
//# sourceMappingURL=redo.js.map