Liferay.Loader.define("layout-content-page-editor-web@2.0.74/page_editor/app/services/ExperienceService", ['module', 'exports', 'require', '../config/index', './serviceFetch'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = void 0;

    var _index = require("../config/index");

    var _serviceFetch = _interopRequireDefault(require("./serviceFetch"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    function getExperienceUsedPortletIds(_ref) {
      var body = _ref.body,
          dispatch = _ref.dispatch;
      var segmentsExperienceId = body.segmentsExperienceId;
      return (0, _serviceFetch["default"])(_index.config.getExperienceUsedPortletsURL, {
        body: {
          segmentsExperienceId: segmentsExperienceId
        }
      }, dispatch);
    }

    var _default = {
      /**
       * Asks backend to create a new experience
       * @param {object} options
       * @param {object} options.body
       * @param {string} options.body.name Name for the new experience
       * @param {string} options.body.segmentsEntryId Id of the segment for the Experience
       * @param {function} options.dispatch
       */
      createExperience: function createExperience(_ref2) {
        var body = _ref2.body,
            dispatch = _ref2.dispatch;
        var name = body.name,
            segmentsEntryId = body.segmentsEntryId;

        return (0, _serviceFetch["default"])(_index.config.addSegmentsExperienceURL, {
          body: {
            active: true,
            name: name,
            segmentsEntryId: segmentsEntryId
          }
        }, dispatch);
      },

      /**
       * Asks backend to remove an experience
       * @param {object} options
       * @param {object} options.body
       * @param {string} options.body.segmentsExperienceId Id of the experience to be deleted
       * @param {function} options.dispatch
       */
      removeExperience: function removeExperience(_ref3) {
        var body = _ref3.body,
            dispatch = _ref3.dispatch;
        var segmentsExperienceId = body.segmentsExperienceId;

        return (0, _serviceFetch["default"])(_index.config.deleteSegmentsExperienceURL, {
          body: {
            segmentsExperienceId: segmentsExperienceId
          }
        }, dispatch);
      },
      selectExperience: function selectExperience(_ref4) {
        var body = _ref4.body,
            dispatch = _ref4.dispatch;
        var segmentsExperienceId = body.segmentsExperienceId;
        return getExperienceUsedPortletIds({
          body: {
            segmentsExperienceId: segmentsExperienceId
          },
          dispatch: dispatch
        });
      },

      /**
       * Asks backend to update an experience name and audience
       * @param {object} options
       * @param {object} options.body
       * @param {string} options.body.name Experience New name for the experience
       * @param {string} options.body.segmentsEntryId New audience for the experience
       * @param {string} options.body.segmentsExperienceId Id of the experience to be updated
       * @param {function} options.dispatch
       */
      updateExperience: function updateExperience(_ref5) {
        var body = _ref5.body,
            dispatch = _ref5.dispatch;
        return (0, _serviceFetch["default"])(_index.config.updateSegmentsExperienceURL, {
          body: body
        }, dispatch);
      },

      /**
       * Asks backend to update an experience priority
       * @param {object} options
       * @param {object} options.body
       * @param {number} options.body.newPriority Priority to update the experience
       * @param {string} options.body.segmentsExperienceId Id of the experience to be updated
       * @param {function} options.dispatch
       */
      updateExperiencePriority: function updateExperiencePriority(_ref6) {
        var body = _ref6.body,
            dispatch = _ref6.dispatch;
        var newPriority = body.newPriority,
            segmentsExperienceId = body.segmentsExperienceId;

        return (0, _serviceFetch["default"])(_index.config.updateSegmentsExperiencePriorityURL, {
          body: {
            newPriority: newPriority,
            segmentsExperienceId: segmentsExperienceId
          }
        }, dispatch);
      }
    };
    exports["default"] = _default;
    //# sourceMappingURL=ExperienceService.js.map
  }
});
//# sourceMappingURL=ExperienceService.js.map