Liferay.Loader.define("layout-content-page-editor-web@2.0.74/page_editor/app/selectors/selectAvailableSidebarPanels", ['module', 'exports', 'require', '../config/constants/viewportSizes', './selectAvailablePanels'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = selectAvailableSidebarPanels;

    var _viewportSizes = require("../config/constants/viewportSizes");

    var _selectAvailablePanels = require("./selectAvailablePanels");

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */

    /**
     * @param {{ [panelId: string]: object }} sidebarPanels
     */
    function selectAvailableSidebarPanels(sidebarPanels) {
      /**
       * @param {{ permissions: import("../../types/ActionKeys").ActionKeysMap, selectedViewportSize: string }} state
       */
      return function (_ref) {
        var permissions = _ref.permissions,
            selectedViewportSize = _ref.selectedViewportSize;
        var availableSidebarPanels = {};

        if (permissions.LOCKED_SEGMENTS_EXPERIMENT || !permissions.UPDATE) {
          _selectAvailablePanels.CONTENT_CHANGE_PANELS.forEach(function (panelId) {
            availableSidebarPanels[panelId] = sidebarPanels[panelId];
          });

          return availableSidebarPanels;
        } else if (selectedViewportSize !== _viewportSizes.VIEWPORT_SIZES.desktop) {
          _selectAvailablePanels.RESPONSIVE_PANELS.forEach(function (panelId) {
            availableSidebarPanels[panelId] = sidebarPanels[panelId];
          });

          return availableSidebarPanels;
        }

        return sidebarPanels;
      };
    }
    //# sourceMappingURL=selectAvailableSidebarPanels.js.map
  }
});
//# sourceMappingURL=selectAvailableSidebarPanels.js.map