Liferay.Loader.define("layout-content-page-editor-web@2.0.74/page_editor/app/reducers/fragmentsReducer", ['module', 'exports', 'require', '../actions/types', '../config/constants/layoutDataItemTypeLabels', '../config/constants/layoutDataItemTypes'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = fragmentsReducer;

    var _types = require("../actions/types");

    var _layoutDataItemTypeLabels = require("../config/constants/layoutDataItemTypeLabels");

    var _layoutDataItemTypes = require("../config/constants/layoutDataItemTypes");

    function _toConsumableArray(arr) {
      return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
    }

    function _nonIterableSpread() {
      throw new TypeError("Invalid attempt to spread non-iterable instance");
    }

    function _iterableToArray(iter) {
      if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
    }

    function _arrayWithoutHoles(arr) {
      if (Array.isArray(arr)) {
        for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
          arr2[i] = arr[i];
        }return arr2;
      }
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    var CONTENT_DISPLAY_COLLECTION_ID = 'content-display';
    var DEFAULT_CONTENT_DISPLAY_COLLECTION = {
      fragmentCollectionId: 'collection-display',
      fragmentEntries: [],
      name: Liferay.Language.get('collection-display')
    };

    function fragmentsReducer() {
      var fragments = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
      var action = arguments.length > 1 ? arguments[1] : undefined;

      switch (action.type) {
        case _types.ADD_FRAGMENT_COMPOSITION:
          {
            var composition = action.fragmentComposition;
            var existingCollection = fragments.find(function (collection) {
              return collection.fragmentCollectionId === composition.fragmentCollectionId;
            });
            var newCollection = existingCollection ? _objectSpread({}, existingCollection, {
              fragmentEntries: [].concat(_toConsumableArray(existingCollection.fragmentEntries), [composition])
            }) : {
              fragmentCollectionId: composition.fragmentCollectionId,
              fragmentEntries: [composition],
              name: composition.fragmentCollectionName
            };
            return [].concat(_toConsumableArray(fragments.filter(function (collection) {
              return collection.fragmentCollectionId !== newCollection.fragmentCollectionId;
            })), [newCollection]);
          }

        case _types.INIT:
          {
            var contentDisplayCollection = fragments.find(function (fragment) {
              return fragment.fragmentCollectionId === CONTENT_DISPLAY_COLLECTION_ID;
            });
            var newFragments = fragments.filter(function (fragment) {
              return fragment.fragmentCollectionId !== CONTENT_DISPLAY_COLLECTION_ID;
            });
            newFragments.unshift({
              fragmentCollectionId: 'layout-elements',
              fragmentEntries: [{
                data: {
                  itemType: _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.container
                },
                icon: 'container',
                itemId: 'container',
                label: _layoutDataItemTypeLabels.LAYOUT_DATA_ITEM_TYPE_LABELS.container,
                type: 'container'
              }, {
                data: {
                  itemType: _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.row
                },
                icon: 'table',
                itemId: 'row',
                label: _layoutDataItemTypeLabels.LAYOUT_DATA_ITEM_TYPE_LABELS.row,
                type: 'row'
              }],
              name: Liferay.Language.get('layout-elements')
            });
            newFragments.splice(2, 0, _objectSpread({}, contentDisplayCollection || DEFAULT_CONTENT_DISPLAY_COLLECTION, {
              fragmentEntries: [].concat(_toConsumableArray((contentDisplayCollection || DEFAULT_CONTENT_DISPLAY_COLLECTION).fragmentEntries), [{
                data: {
                  itemType: _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.collection
                },
                icon: 'list',
                itemId: 'collection-display',
                label: Liferay.Language.get('collection-display'),
                type: _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.collection
              }])
            }));
            return newFragments;
          }

        default:
          return fragments;
      }
    }
    //# sourceMappingURL=fragmentsReducer.js.map
  }
});
//# sourceMappingURL=fragmentsReducer.js.map