Liferay.Loader.define("layout-content-page-editor-web@2.0.74/page_editor/app/components/undo/undoDeleteItem", ['module', 'exports', 'require', '../../actions/addItem', '../../services/LayoutService'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.undoAction = undoAction;
    exports.getDerivedStateForUndo = getDerivedStateForUndo;

    var _addItem = _interopRequireDefault(require("../../actions/addItem"));

    var _LayoutService = _interopRequireDefault(require("../../services/LayoutService"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    function undoAction(_ref) {
      var action = _ref.action,
          store = _ref.store;
      var itemId = action.itemId,
          portletIds = action.portletIds;
      return function (dispatch) {
        return _LayoutService["default"].unmarkItemForDeletion({
          itemId: itemId,
          onNetworkStatus: dispatch,
          segmentsExperienceId: store.segmentsExperienceId
        }).then(function (_ref2) {
          var layoutData = _ref2.layoutData;
          dispatch((0, _addItem["default"])({
            itemId: itemId,
            layoutData: layoutData,
            portletIds: portletIds
          }));
        });
      };
    }

    function getDerivedStateForUndo(_ref3) {
      var action = _ref3.action;
      return {
        itemId: action.itemId,
        portletIds: action.portletIds
      };
    }
    //# sourceMappingURL=undoDeleteItem.js.map
  }
});
//# sourceMappingURL=undoDeleteItem.js.map