Liferay.Loader.define("layout-content-page-editor-web@2.0.74/page_editor/app/components/undo/UndoHistory", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/drop-down', '@frontend-taglib-clay$clayui/drop-down/lib/Divider', 'frontend-js-react-web', 'frontend-js-react-web$react', 'frontend-js-react-web$react-dom', '../../../plugins/experience/actions', '../../config/constants/undoTypes', '../../config/index', '../../store/index', '../../thunks/multipleUndo', '../../utils/getSegmentsExperienceName', './getActionLabel'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = UndoHistory;

    var _button = require("@frontend-taglib-clay$clayui/button");

    var _dropDown = _interopRequireWildcard(require("@frontend-taglib-clay$clayui/drop-down"));

    var _Divider = _interopRequireDefault(require("@frontend-taglib-clay$clayui/drop-down/lib/Divider"));

    var _frontendJsReactWeb = require("frontend-js-react-web");

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _reactDom = _interopRequireDefault(require("frontend-js-react-web$react-dom"));

    var _actions = require("../../../plugins/experience/actions");

    var _undoTypes = require("../../config/constants/undoTypes");

    var _index = require("../../config/index");

    var _index2 = require("../../store/index");

    var _multipleUndo = _interopRequireDefault(require("../../thunks/multipleUndo"));

    var _getSegmentsExperienceName = _interopRequireDefault(require("../../utils/getSegmentsExperienceName"));

    var _getActionLabel = _interopRequireDefault(require("./getActionLabel"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _toConsumableArray(arr) {
      return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
    }

    function _nonIterableSpread() {
      throw new TypeError("Invalid attempt to spread non-iterable instance");
    }

    function _iterableToArray(iter) {
      if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
    }

    function _arrayWithoutHoles(arr) {
      if (Array.isArray(arr)) {
        for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
          arr2[i] = arr[i];
        }return arr2;
      }
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    function UndoHistory() {
      var dispatch = (0, _index2.useDispatch)();
      var store = (0, _index2.useSelector)(function (state) {
        return state;
      });
      var redoHistory = (0, _index2.useSelector)(function (state) {
        return state.redoHistory || [];
      });
      var undoHistory = (0, _index2.useSelector)(function (state) {
        return state.undoHistory || [];
      });
      var isMounted = (0, _frontendJsReactWeb.useIsMounted)();

      var _useState = (0, _react.useState)(false),
          _useState2 = _slicedToArray(_useState, 2),
          active = _useState2[0],
          setActive = _useState2[1];

      var _useState3 = (0, _react.useState)(false),
          _useState4 = _slicedToArray(_useState3, 2),
          loading = _useState4[0],
          setLoading = _useState4[1];

      var onHistoryItemClick = function onHistoryItemClick(event, numberOfActions, type) {
        event.preventDefault();
        setLoading(true);
        dispatch((0, _multipleUndo["default"])({
          numberOfActions: numberOfActions,
          store: store,
          type: type
        }))["finally"](function () {
          if (isMounted()) {
            setLoading(false);
          }
        });
      };

      return _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement(_dropDown["default"], {
        active: active,
        alignmentPosition: _dropDown.Align.BottomRight,
        className: "mr-3",
        menuElementAttrs: {
          className: 'page-editor__undo-history'
        },
        onActiveChange: setActive,
        trigger: _react["default"].createElement(_button.ClayButtonWithIcon, {
          "aria-label": Liferay.Language.get('history'),
          "aria-pressed": active,
          disabled: !undoHistory.length && !redoHistory.length,
          displayType: "secondary",
          small: true,
          symbol: "time",
          title: Liferay.Language.get('history')
        })
      }, _react["default"].createElement(_dropDown["default"].ItemList, null, _react["default"].createElement(History, {
        actions: redoHistory,
        onHistoryItemClick: onHistoryItemClick,
        type: _undoTypes.UNDO_TYPES.redo
      }), _react["default"].createElement(History, {
        actions: undoHistory,
        onHistoryItemClick: onHistoryItemClick,
        type: _undoTypes.UNDO_TYPES.undo
      }), _react["default"].createElement(_Divider["default"], null), _react["default"].createElement(_dropDown["default"].Item, {
        disabled: !undoHistory.length,
        onClick: function onClick(event) {
          return onHistoryItemClick(event, undoHistory.length, _undoTypes.UNDO_TYPES.undo);
        }
      }, Liferay.Language.get('undo-all')))), loading && _reactDom["default"].createPortal(_react["default"].createElement(Overlay, null), document.body));
    }

    var Overlay = function Overlay() {
      (0, _frontendJsReactWeb.useEventListener)('keydown', function (event) {
        event.preventDefault();
        event.stopPropagation();
        event.stopImmediatePropagation();
      }, true, window);
      return _react["default"].createElement("div", {
        className: 'page-editor__undo-history__overlay',
        onClickCapture: function onClickCapture(event) {
          event.preventDefault();
          event.stopPropagation();
        }
      });
    };

    var History = function History(_ref) {
      var _ref$actions = _ref.actions,
          actions = _ref$actions === void 0 ? [] : _ref$actions,
          type = _ref.type,
          onHistoryItemClick = _ref.onHistoryItemClick;
      var store = (0, _index2.useSelector)(function (state) {
        return state;
      });

      var isSelectedAction = function isSelectedAction(index) {
        return type === _undoTypes.UNDO_TYPES.undo && index === 0;
      };

      var actionList = type === _undoTypes.UNDO_TYPES.undo ? actions : _toConsumableArray(actions).reverse();
      return actionList.map(function (action, index) {
        return _react["default"].createElement(_dropDown["default"].Item, {
          disabled: isSelectedAction(index),
          key: action.actionId,
          onClick: function onClick(event) {
            var numberOfActions = type === _undoTypes.UNDO_TYPES.undo ? index : actionList.length - index;
            onHistoryItemClick(event, numberOfActions, type);
          },
          symbolRight: isSelectedAction(index) ? 'check' : ''
        }, (0, _getActionLabel["default"])(action, type, {
          availableSegmentsExperiences: store.availableSegmentsExperiences
        }), action.type !== _actions.SELECT_SEGMENTS_EXPERIENCE && action.segmentsExperienceId !== _index.config.defaultSegmentsExperienceId && !_index.config.singleSegmentsExperienceMode && _react["default"].createElement("span", null, (0, _getSegmentsExperienceName["default"])(action.segmentsExperienceId, store.availableSegmentsExperiences)));
      });
    };
    //# sourceMappingURL=UndoHistory.js.map
  }
});
//# sourceMappingURL=UndoHistory.js.map