Liferay.Loader.define("layout-content-page-editor-web@2.0.74/page_editor/app/components/Toolbar", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/layout', '@frontend-taglib-clay$clayui/modal', 'frontend-js-react-web', 'frontend-js-react-web$react', 'frontend-js-react-web$react-dom', '../../core/hooks/useLazy', '../../core/hooks/useLoad', '../../core/hooks/usePlugins', '../actions/index', '../config/constants/layoutTypes', '../config/index', '../store/index', '../thunks/redo', '../thunks/undo', '../utils/dragAndDrop/useDragAndDrop', './Controls', './EditModeSelector', './ExperimentsLabel', './NetworkStatusBar', './PreviewModal', './Translation', './UnsafeHTML', './ViewportSizeSelector', './undo/Undo'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = Toolbar;

    var _button = _interopRequireWildcard(require("@frontend-taglib-clay$clayui/button"));

    var _layout = _interopRequireDefault(require("@frontend-taglib-clay$clayui/layout"));

    var _modal = require("@frontend-taglib-clay$clayui/modal");

    var _frontendJsReactWeb = require("frontend-js-react-web");

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _reactDom = _interopRequireDefault(require("frontend-js-react-web$react-dom"));

    var _useLazy = _interopRequireDefault(require("../../core/hooks/useLazy"));

    var _useLoad = _interopRequireDefault(require("../../core/hooks/useLoad"));

    var _usePlugins2 = _interopRequireDefault(require("../../core/hooks/usePlugins"));

    var Actions = _interopRequireWildcard(require("../actions/index"));

    var _layoutTypes = require("../config/constants/layoutTypes");

    var _index2 = require("../config/index");

    var _index3 = require("../store/index");

    var _redo = _interopRequireDefault(require("../thunks/redo"));

    var _undo = _interopRequireDefault(require("../thunks/undo"));

    var _useDragAndDrop = require("../utils/dragAndDrop/useDragAndDrop");

    var _Controls = require("./Controls");

    var _EditModeSelector = _interopRequireDefault(require("./EditModeSelector"));

    var _ExperimentsLabel = _interopRequireDefault(require("./ExperimentsLabel"));

    var _NetworkStatusBar = _interopRequireDefault(require("./NetworkStatusBar"));

    var _PreviewModal = _interopRequireDefault(require("./PreviewModal"));

    var _Translation = _interopRequireDefault(require("./Translation"));

    var _UnsafeHTML = _interopRequireDefault(require("./UnsafeHTML"));

    var _ViewportSizeSelector = _interopRequireDefault(require("./ViewportSizeSelector"));

    var _Undo = _interopRequireDefault(require("./undo/Undo"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    function _classCallCheck(instance, Constructor) {
      if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
      }
    }

    function _possibleConstructorReturn(self, call) {
      if (call && (_typeof(call) === "object" || typeof call === "function")) {
        return call;
      }return _assertThisInitialized(self);
    }

    function _assertThisInitialized(self) {
      if (self === void 0) {
        throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
      }return self;
    }

    function _getPrototypeOf(o) {
      _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
        return o.__proto__ || Object.getPrototypeOf(o);
      };return _getPrototypeOf(o);
    }

    function _defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
      }
    }

    function _createClass(Constructor, protoProps, staticProps) {
      if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
    }

    function _inherits(subClass, superClass) {
      if (typeof superClass !== "function" && superClass !== null) {
        throw new TypeError("Super expression must either be null or a function");
      }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
    }

    function _setPrototypeOf(o, p) {
      _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
        o.__proto__ = p;return o;
      };return _setPrototypeOf(o, p);
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var Suspense = _react["default"].Suspense,
        useCallback = _react["default"].useCallback,
        useRef = _react["default"].useRef;

    function ToolbarBody() {
      var dispatch = (0, _index3.useDispatch)();
      var dropClearRef = (0, _useDragAndDrop.useDropClear)();

      var _usePlugins = (0, _usePlugins2["default"])(),
          getInstance = _usePlugins.getInstance,
          register = _usePlugins.register;

      var isMounted = (0, _frontendJsReactWeb.useIsMounted)();
      var load = (0, _useLoad["default"])();
      var selectItem = (0, _Controls.useSelectItem)();
      var store = (0, _index3.useSelector)(function (state) {
        return state;
      });
      var network = store.network,
          segmentsExperienceId = store.segmentsExperienceId,
          segmentsExperimentStatus = store.segmentsExperimentStatus,
          selectedViewportSize = store.selectedViewportSize;

      var _useState = (0, _react.useState)(false),
          _useState2 = _slicedToArray(_useState, 2),
          openPreviewModal = _useState2[0],
          setOpenPreviewModal = _useState2[1];

      var _useModal = (0, _modal.useModal)({
        onClose: function onClose() {
          if (isMounted()) {
            setOpenPreviewModal(false);
          }
        }
      }),
          observer = _useModal.observer;

      var loading = useRef(function () {
        Promise.all(_index2.config.toolbarPlugins.map(function (toolbarPlugin) {
          var pluginEntryPoint = toolbarPlugin.pluginEntryPoint;
          var promise = load(pluginEntryPoint, pluginEntryPoint);
          var app = {
            Actions: Actions,
            config: _index2.config,
            dispatch: dispatch,
            store: store
          };
          return register(pluginEntryPoint, promise, {
            app: app,
            toolbarPlugin: toolbarPlugin
          }).then(function (plugin) {
            if (!plugin) {
              throw new Error("Failed to get instance from ".concat(pluginEntryPoint));
            } else if (isMounted()) {
              if (typeof plugin.activate === 'function') {
                plugin.activate();
              }
            }
          });
        }))["catch"](function (error) {});
      });

      if (loading.current) {
        // Do this once only.
        loading.current();
        loading.current = null;
      }

      var ToolbarSection = (0, _useLazy["default"])(useCallback(function (_ref) {
        var instance = _ref.instance;

        if (typeof instance.renderToolbarSection === 'function') {
          return instance.renderToolbarSection();
        } else {
          return null;
        }
      }, []));

      var deselectItem = function deselectItem(event) {
        if (event.target === event.currentTarget) {
          selectItem(null);
        }
      };

      var publishButtonLabel = Liferay.Language.get('publish');

      if (_index2.config.layoutType === _layoutTypes.LAYOUT_TYPES.master) {
        publishButtonLabel = Liferay.Language.get('publish-master');
      } else if (_index2.config.singleSegmentsExperienceMode) {
        publishButtonLabel = Liferay.Language.get('save-variant');
      } else if (_index2.config.workflowEnabled) {
        publishButtonLabel = Liferay.Language.get('submit-for-publication');
      }

      return _react["default"].createElement(_layout["default"].ContainerFluid, {
        onClick: deselectItem,
        ref: dropClearRef
      }, _react["default"].createElement("ul", {
        className: "navbar-nav responsive-mode",
        onClick: deselectItem
      }, _index2.config.toolbarPlugins.map(function (_ref2) {
        var loadingPlaceholder = _ref2.loadingPlaceholder,
            pluginEntryPoint = _ref2.pluginEntryPoint;
        return _react["default"].createElement("li", {
          className: "nav-item",
          key: pluginEntryPoint
        }, _react["default"].createElement(ErrorBoundary, null, _react["default"].createElement(Suspense, {
          fallback: _react["default"].createElement(_UnsafeHTML["default"], {
            markup: loadingPlaceholder
          })
        }, _react["default"].createElement(ToolbarSection, {
          getInstance: getInstance,
          pluginId: pluginEntryPoint
        }))));
      }), _react["default"].createElement("li", {
        className: "nav-item"
      }, _react["default"].createElement(_Translation["default"], {
        availableLanguages: _index2.config.availableLanguages,
        defaultLanguageId: _index2.config.defaultLanguageId,
        dispatch: dispatch,
        fragmentEntryLinks: store.fragmentEntryLinks,
        languageId: store.languageId,
        segmentsExperienceId: segmentsExperienceId
      })), !_index2.config.singleSegmentsExperienceMode && segmentsExperimentStatus && _react["default"].createElement("li", {
        className: "nav-item pl-2"
      }, _react["default"].createElement(_ExperimentsLabel["default"], {
        label: segmentsExperimentStatus.label,
        value: segmentsExperimentStatus.value
      })), _react["default"].createElement("li", {
        className: "nav-item"
      }, _react["default"].createElement(_ViewportSizeSelector["default"], {
        onSizeSelected: function onSizeSelected(size) {
          return dispatch(Actions.switchViewportSize({
            size: size
          }));
        },
        selectedSize: selectedViewportSize
      }))), _react["default"].createElement("ul", {
        className: "navbar-nav",
        onClick: deselectItem
      }, _react["default"].createElement(_NetworkStatusBar["default"], network), _react["default"].createElement(_Undo["default"], {
        onRedo: function onRedo() {
          dispatch((0, _redo["default"])({
            store: store
          }));
        },
        onUndo: function onUndo() {
          dispatch((0, _undo["default"])({
            store: store
          }));
        }
      }), _react["default"].createElement("li", {
        className: "nav-item"
      }, _react["default"].createElement(_EditModeSelector["default"], null)), _react["default"].createElement("li", {
        className: "nav-item"
      }, _react["default"].createElement(_button.ClayButtonWithIcon, {
        className: "btn btn-secondary mr-3",
        displayType: "secondary",
        onClick: function onClick() {
          return setOpenPreviewModal(true);
        },
        small: true,
        symbol: "view",
        title: Liferay.Language.get('preview'),
        type: "button"
      }, Liferay.Language.get('preview'))), _index2.config.singleSegmentsExperienceMode && _react["default"].createElement("li", {
        className: "nav-item"
      }, _react["default"].createElement("form", {
        action: _index2.config.discardDraftURL,
        method: "POST"
      }, _react["default"].createElement("input", {
        name: "".concat(_index2.config.portletNamespace, "redirect"),
        type: "hidden",
        value: _index2.config.discardDraftRedirectURL
      }), _react["default"].createElement(_button["default"], {
        className: "btn btn-secondary mr-3",
        displayType: "secondary",
        onClick: function handleDiscardVariant(event) {
          if (!confirm(Liferay.Language.get('are-you-sure-you-want-to-discard-current-draft-and-apply-latest-published-changes'))) {
            event.preventDefault();
          }
        },
        small: true,
        type: "submit"
      }, Liferay.Language.get('discard-variant')))), _react["default"].createElement("li", {
        className: "nav-item"
      }, _react["default"].createElement("form", {
        action: _index2.config.publishURL,
        method: "POST"
      }, _react["default"].createElement("input", {
        name: "".concat(_index2.config.portletNamespace, "redirect"),
        type: "hidden",
        value: _index2.config.redirectURL
      }), _react["default"].createElement(_button["default"], {
        disabled: _index2.config.pending,
        displayType: "primary",
        onClick: function handleSubmit(event) {
          if (_index2.config.masterUsed && !confirm(Liferay.Language.get('changes-made-on-this-master-are-going-to-be-propagated-to-all-page-templates,-display-page-templates,-and-pages-using-it.are-you-sure-you-want-to-proceed'))) {
            event.preventDefault();
          }
        },
        small: true,
        type: "submit"
      }, publishButtonLabel)))), openPreviewModal && _react["default"].createElement(_PreviewModal["default"], {
        observer: observer
      }));
    }

    var ErrorBoundary = /*#__PURE__*/function (_React$Component) {
      _inherits(ErrorBoundary, _React$Component);

      _createClass(ErrorBoundary, null, [{
        key: "getDerivedStateFromError",
        value: function getDerivedStateFromError(_error) {
          return {
            hasError: true
          };
        }
      }]);

      function ErrorBoundary(props) {
        var _this;

        _classCallCheck(this, ErrorBoundary);

        _this = _possibleConstructorReturn(this, _getPrototypeOf(ErrorBoundary).call(this, props));
        _this.state = {
          hasError: false
        };
        return _this;
      }

      _createClass(ErrorBoundary, [{
        key: "componentDidCatch",
        value: function componentDidCatch(error) {}
      }, {
        key: "render",
        value: function render() {
          if (this.state.hasError) {
            return null;
          } else {
            return this.props.children;
          }
        }
      }]);

      return ErrorBoundary;
    }(_react["default"].Component);

    function Toolbar() {
      var container = document.getElementById(_index2.config.toolbarId);
      var isMounted = (0, _frontendJsReactWeb.useIsMounted)();

      if (!isMounted()) {
        // First time here, must empty JSP-rendered markup from container.
        while (container.firstChild) {
          container.removeChild(container.firstChild);
        }
      }

      return _reactDom["default"].createPortal(_react["default"].createElement(ToolbarBody, null), container);
    }
    //# sourceMappingURL=Toolbar.js.map
  }
});
//# sourceMappingURL=Toolbar.js.map