Liferay.Loader.define("layout-content-page-editor-web@2.0.74/page_editor/app/components/SaveFragmentCompositionModal", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/card', '@frontend-taglib-clay$clayui/form', '@frontend-taglib-clay$clayui/icon', '@frontend-taglib-clay$clayui/layout', '@frontend-taglib-clay$clayui/modal', '@frontend-taglib-clay$clayui/sticker', 'frontend-js-react-web', 'frontend-js-web', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../common/components/Button', '../../common/components/InvisibleFieldset', '../../core/openImageSelector', '../config/index', '../selectors/selectSegmentsExperienceId', '../store/index', '../thunks/addFragmentComposition', './Controls'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = void 0;

    var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

    var _card = _interopRequireDefault(require("@frontend-taglib-clay$clayui/card"));

    var _form = _interopRequireWildcard(require("@frontend-taglib-clay$clayui/form"));

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _layout = _interopRequireDefault(require("@frontend-taglib-clay$clayui/layout"));

    var _modal = _interopRequireWildcard(require("@frontend-taglib-clay$clayui/modal"));

    var _sticker = _interopRequireDefault(require("@frontend-taglib-clay$clayui/sticker"));

    var _frontendJsReactWeb = require("frontend-js-react-web");

    var _frontendJsWeb = require("frontend-js-web");

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _Button = _interopRequireDefault(require("../../common/components/Button"));

    var _InvisibleFieldset = _interopRequireDefault(require("../../common/components/InvisibleFieldset"));

    var _openImageSelector = require("../../core/openImageSelector");

    var _index = require("../config/index");

    var _selectSegmentsExperienceId = _interopRequireDefault(require("../selectors/selectSegmentsExperienceId"));

    var _index2 = require("../store/index");

    var _addFragmentComposition = _interopRequireDefault(require("../thunks/addFragmentComposition"));

    var _Controls = require("./Controls");

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var SaveFragmentCompositionModal = function SaveFragmentCompositionModal(_ref) {
      var onCloseModal = _ref.onCloseModal,
          open = _ref.open;
      var dispatch = (0, _index2.useDispatch)();
      var segmentsExperienceId = (0, _index2.useSelector)(_selectSegmentsExperienceId["default"]);
      var activeItemId = (0, _Controls.useActiveItemId)();
      var isMounted = (0, _frontendJsReactWeb.useIsMounted)();
      var collections = (0, _index2.useSelector)(function (state) {
        return state.collections || [];
      });

      var _useState = (0, _react.useState)(undefined),
          _useState2 = _slicedToArray(_useState, 2),
          name = _useState2[0],
          setName = _useState2[1];

      var _useState3 = (0, _react.useState)(''),
          _useState4 = _slicedToArray(_useState3, 2),
          description = _useState4[0],
          setDescription = _useState4[1];

      var _useState5 = (0, _react.useState)(collections.length > 0 ? collections[0].fragmentCollectionId : -1),
          _useState6 = _slicedToArray(_useState5, 2),
          fragmentCollectionId = _useState6[0],
          setFragmentCollectionId = _useState6[1];

      var _useState7 = (0, _react.useState)(false),
          _useState8 = _slicedToArray(_useState7, 2),
          saveInlineContent = _useState8[0],
          setSaveInlineContent = _useState8[1];

      var _useState9 = (0, _react.useState)(false),
          _useState10 = _slicedToArray(_useState9, 2),
          saveMappingConfiguration = _useState10[0],
          setSaveMappingConfiguration = _useState10[1];

      var _useModal = (0, _modal.useModal)({
        onClose: function onClose() {
          if (isMounted()) {
            onCloseModal();
          }
        }
      }),
          observer = _useModal.observer,
          onClose = _useModal.onClose;

      var _useState11 = (0, _react.useState)({}),
          _useState12 = _slicedToArray(_useState11, 2),
          thumbnail = _useState12[0],
          setThumbnail = _useState12[1];

      var handleSubmit = function handleSubmit(event) {
        event.preventDefault();

        if (!name) {
          setName('');
        } else {
          setLoading(true);
          dispatch((0, _addFragmentComposition["default"])({
            description: description,
            fragmentCollectionId: fragmentCollectionId,
            itemId: activeItemId,
            name: name,
            previewImageURL: thumbnail.url,
            saveInlineContent: saveInlineContent,
            saveMappingConfiguration: saveMappingConfiguration,
            segmentsExperienceId: segmentsExperienceId
          })).then(function () {
            onClose();
          })["catch"](function () {
            (0, _frontendJsWeb.openToast)({
              message: Liferay.Language.get('an-unexpected-error-occurred'),
              type: 'danger'
            });
            setLoading(false);
          });
        }
      };

      var handleThumbnailSelected = function handleThumbnailSelected(image) {
        setThumbnail(image);
      };

      var _useState13 = (0, _react.useState)(false),
          _useState14 = _slicedToArray(_useState13, 2),
          loading = _useState14[0],
          setLoading = _useState14[1];

      var nameInputId = "".concat(_index.config.portletNamespace, "fragmentCompositionName");
      var descriptionInputId = "".concat(_index.config.portletNamespace, "fragmentCompositionDescription");
      return open && _react["default"].createElement(_modal["default"], {
        className: "page-editor__save-fragment-composition-modal",
        observer: observer,
        size: "lg"
      }, _react["default"].createElement(_modal["default"].Header, null, Liferay.Language.get('save-as-fragment')), _react["default"].createElement(_modal["default"].Body, {
        scrollable: true
      }, _react["default"].createElement(_form["default"], {
        autoComplete: "off",
        className: "mb-3",
        noValidate: true,
        onSubmit: handleSubmit
      }, _react["default"].createElement(_InvisibleFieldset["default"], {
        disabled: loading
      }, _react["default"].createElement(_form["default"].Group, {
        className: name === '' ? 'has-error mb-3' : 'mb-3'
      }, _react["default"].createElement("label", {
        htmlFor: nameInputId
      }, Liferay.Language.get('name'), _react["default"].createElement(_icon["default"], {
        className: "ml-1 reference-mark",
        focusable: "false",
        role: "presentation",
        symbol: "asterisk"
      })), _react["default"].createElement(_form.ClayInput, {
        autoFocus: true,
        id: nameInputId,
        onChange: function onChange(event) {
          return setName(event.target.value);
        },
        placeholder: Liferay.Language.get('name'),
        required: true,
        type: "text",
        value: name || ''
      }), name === '' && _react["default"].createElement(_form["default"].FeedbackGroup, null, _react["default"].createElement(_form["default"].FeedbackItem, null, _react["default"].createElement(_form["default"].FeedbackIndicator, {
        symbol: "exclamation-full"
      }), Liferay.Language.get('this-field-is-required')))), _react["default"].createElement(_form["default"].Group, null, _react["default"].createElement(_form.ClayInput.Group, null, _react["default"].createElement(_form.ClayInput.GroupItem, {
        shrink: true
      }, _react["default"].createElement(_button["default"], {
        displayType: "secondary",
        onClick: function onClick() {
          return (0, _openImageSelector.openImageSelector)(handleThumbnailSelected);
        },
        small: true,
        value: Liferay.Language.get('upload-thumbnail')
      }, _react["default"].createElement(_icon["default"], {
        className: "mr-2",
        focusable: "false",
        monospaced: "true",
        role: "presentation",
        symbol: "upload"
      }), Liferay.Language.get('upload-thumbnail'))), _react["default"].createElement(_form.ClayInput.GroupItem, {
        className: "align-items-center"
      }, _react["default"].createElement("span", {
        className: "ml-2 text-truncate"
      }, thumbnail.title)))), _react["default"].createElement(_form["default"].Group, null, _react["default"].createElement("label", {
        htmlFor: descriptionInputId
      }, Liferay.Language.get('description')), _react["default"].createElement(_form.ClayInput, {
        component: "textarea",
        id: descriptionInputId,
        onChange: function onChange(event) {
          return setDescription(event.target.value);
        },
        placeholder: Liferay.Language.get('description'),
        type: "text",
        value: description
      })), _react["default"].createElement(_form["default"].Group, null, _react["default"].createElement(_form.ClayInput.Group, {
        className: "input-group-stacked-sm-down"
      }, _react["default"].createElement(_form.ClayInput.GroupItem, {
        className: "mr-4",
        shrink: true
      }, _react["default"].createElement(_form.ClayCheckbox, {
        checked: saveInlineContent,
        id: "".concat(_index.config.portletNamespace, "saveInlineContent"),
        label: Liferay.Language.get('save-inline-content'),
        onChange: function onChange(event) {
          return setSaveInlineContent(event.target.checked);
        }
      })), _react["default"].createElement(_form.ClayInput.GroupItem, null, _react["default"].createElement(_form.ClayCheckbox, {
        checked: saveMappingConfiguration,
        id: "".concat(_index.config.portletNamespace, "saveMappingConfiguration"),
        label: Liferay.Language.get('save-mapping-configuration'),
        onChange: function onChange(event) {
          return setSaveMappingConfiguration(event.target.checked);
        }
      })))), _react["default"].createElement(_form["default"].Group, null, collections.length > 0 ? _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement("p", {
        className: "sheet-tertiary-title"
      }, Liferay.Language.get('select-collection')), _react["default"].createElement(_layout["default"].Row, null, collections.map(function (collection) {
        return _react["default"].createElement(_layout["default"].Col, {
          key: collection.fragmentCollectionId,
          md: "4"
        }, _react["default"].createElement(_card["default"], {
          className: fragmentCollectionId === collection.fragmentCollectionId ? 'active' : '',
          horizontal: true,
          interactive: true,
          onClick: function onClick() {
            return setFragmentCollectionId(collection.fragmentCollectionId);
          }
        }, _react["default"].createElement(_card["default"].Body, null, _react["default"].createElement(_card["default"].Row, null, _react["default"].createElement(_layout["default"].ContentCol, {
          containerElement: "span"
        }, _react["default"].createElement(_sticker["default"], {
          inline: true
        }, _react["default"].createElement(_icon["default"], {
          symbol: "folder"
        }))), _react["default"].createElement(_layout["default"].ContentCol, {
          containerElement: "span",
          expand: true
        }, _react["default"].createElement(_layout["default"].ContentSection, {
          containerElement: "span"
        }, _react["default"].createElement(_card["default"].Description, {
          displayType: "title",
          truncate: true
        }, collection.name)))))));
      }))) : _react["default"].createElement("div", {
        className: "alert alert-info"
      }, _react["default"].createElement(_icon["default"], {
        className: "inline-item inline-item-after mr-2 reference-mark",
        focusable: "false",
        role: "presentation",
        symbol: "exclamation-full"
      }), Liferay.Language.get('this-fragment-will-be-saved-in-a-new-collection-called-saved-fragments')))))), _react["default"].createElement(_modal["default"].Footer, {
        last: _react["default"].createElement(_button["default"].Group, {
          spaced: true
        }, _react["default"].createElement(_button["default"], {
          disabled: loading,
          displayType: "secondary",
          onClick: onClose
        }, Liferay.Language.get('cancel')), _react["default"].createElement(_Button["default"], {
          disabled: loading,
          displayType: "primary",
          loading: loading,
          onClick: handleSubmit
        }, Liferay.Language.get('save')))
      }));
    };

    var _default = SaveFragmentCompositionModal;
    exports["default"] = _default;
    //# sourceMappingURL=SaveFragmentCompositionModal.js.map
  }
});
//# sourceMappingURL=SaveFragmentCompositionModal.js.map