Liferay.Loader.define("layout-content-page-editor-web@2.0.74/page_editor/app/components/PreviewModal", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/form', '@frontend-taglib-clay$clayui/layout', '@frontend-taglib-clay$clayui/modal', 'frontend-js-web', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../config/constants/viewportSizes', '../config/index', '../store/index', '../utils/useId', './Translation', './ViewportSizeSelector'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = void 0;

    var _form = require("@frontend-taglib-clay$clayui/form");

    var _layout = _interopRequireDefault(require("@frontend-taglib-clay$clayui/layout"));

    var _modal = _interopRequireDefault(require("@frontend-taglib-clay$clayui/modal"));

    var _frontendJsWeb = require("frontend-js-web");

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _viewportSizes = require("../config/constants/viewportSizes");

    var _index = require("../config/index");

    var _index2 = require("../store/index");

    var _useId = require("../utils/useId");

    var _Translation = _interopRequireDefault(require("./Translation"));

    var _ViewportSizeSelector = _interopRequireDefault(require("./ViewportSizeSelector"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var PreviewModal = function PreviewModal(_ref) {
      var observer = _ref.observer;

      var _useState = (0, _react.useState)((0, _index2.useSelector)(function (state) {
        return state.languageId;
      })),
          _useState2 = _slicedToArray(_useState, 2),
          languageId = _useState2[0],
          setLanguageId = _useState2[1];

      var _useState3 = (0, _react.useState)((0, _index2.useSelector)(function (state) {
        return state.selectedViewportSize;
      })),
          _useState4 = _slicedToArray(_useState3, 2),
          viewportSize = _useState4[0],
          setViewportSize = _useState4[1];

      var initialSegmentsExperienceId = (0, _index2.useSelector)(function (state) {
        return state.segmentsExperienceId;
      });
      var fragmentEntryLinks = (0, _index2.useSelector)(function (state) {
        return state.fragmentEntryLinks;
      });

      var _useState5 = (0, _react.useState)(initialSegmentsExperienceId),
          _useState6 = _slicedToArray(_useState5, 2),
          segmentsExperienceId = _useState6[0],
          setSegmentsExperienceId = _useState6[1];

      var availableSegmentsExperiences = (0, _index2.useSelector)(function (state) {
        return state.availableSegmentsExperiences;
      });
      var experienceSelectId = (0, _useId.useId)();
      var previewURL = (0, _react.useMemo)(function () {
        var _addParams;

        return (0, _frontendJsWeb.addParams)((_addParams = {}, _defineProperty(_addParams, "".concat(_index.config.portletNamespace, "languageId"), languageId), _defineProperty(_addParams, "".concat(_index.config.portletNamespace, "segmentsExperienceId"), segmentsExperienceId), _addParams), _index.config.previewPageURL);
      }, [languageId, segmentsExperienceId]);
      var modalBodyWidth = (0, _react.useMemo)(function () {
        var _config$availableView = _index.config.availableViewportSizes[viewportSize],
            maxWidth = _config$availableView.maxWidth,
            minWidth = _config$availableView.minWidth;
        return viewportSize === _viewportSizes.VIEWPORT_SIZES.desktop ? '100%' : (maxWidth + minWidth) / 2;
      }, [viewportSize]);
      return _react["default"].createElement(_modal["default"], {
        className: "page-editor__preview-modal",
        observer: observer,
        size: "full-screen"
      }, _react["default"].createElement(_modal["default"].Header, null, _react["default"].createElement(_layout["default"].ContainerFluid, {
        size: false
      }, _react["default"].createElement(_modal["default"].Title, {
        className: "pb-3 pt-3"
      }, _react["default"].createElement("div", {
        className: "d-flex justify-content-between responsive-mode"
      }, _react["default"].createElement("ul", {
        className: "navbar-nav page-editor__preview-modal__part"
      }, availableSegmentsExperiences && _react["default"].createElement("li", {
        className: "mr-2 nav-item"
      }, _react["default"].createElement("div", {
        className: "align-middle d-inline-flex"
      }, _react["default"].createElement("label", {
        className: "mr-2 mt-1",
        htmlFor: experienceSelectId
      }, Liferay.Language.get('experience')), _react["default"].createElement(_form.ClaySelect, {
        "aria-label": "Experience",
        className: "form-control-sm",
        id: experienceSelectId,
        onChange: function onChange(event) {
          setSegmentsExperienceId(event.target.options[event.target.selectedIndex].value);
        },
        value: segmentsExperienceId
      }, availableSegmentsExperiences && Object.keys(availableSegmentsExperiences).map(function (segmentsExperienceId) {
        return _react["default"].createElement(_form.ClaySelect.Option, {
          key: segmentsExperienceId,
          label: availableSegmentsExperiences[segmentsExperienceId].name,
          value: segmentsExperienceId
        });
      })))), _react["default"].createElement("li", {
        className: "nav-item"
      }, _react["default"].createElement(_Translation["default"], {
        availableLanguages: _index.config.availableLanguages,
        defaultLanguageId: _index.config.defaultLanguageId,
        dispatch: function dispatch(_ref2) {
          var nextLanguageId = _ref2.languageId;
          return setLanguageId(nextLanguageId);
        },
        fragmentEntryLinks: fragmentEntryLinks,
        languageId: languageId,
        segmentsExperienceId: segmentsExperienceId,
        showNotTranslated: false
      }))), _react["default"].createElement("div", {
        className: "page-editor__preview-modal__part"
      }, _react["default"].createElement(_ViewportSizeSelector["default"], {
        onSizeSelected: setViewportSize,
        selectedSize: viewportSize
      })), _react["default"].createElement("div", {
        className: "page-editor__preview-modal__part"
      }))))), _react["default"].createElement(_modal["default"].Body, {
        iFrameProps: {
          style: {
            maxWidth: modalBodyWidth
          }
        },
        url: previewURL
      }));
    };

    var _default = PreviewModal;
    exports["default"] = _default;
    //# sourceMappingURL=PreviewModal.js.map
  }
});
//# sourceMappingURL=PreviewModal.js.map