Liferay.Loader.define("layout-content-page-editor-web@2.0.74/page_editor/app/components/ItemActions", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/drop-down', '@frontend-taglib-clay$clayui/icon', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../prop-types/index', '../store/index', '../thunks/deleteItem', '../thunks/duplicateItem', '../utils/canBeDuplicated', '../utils/canBeRemoved', '../utils/canBeSaved', './Controls', './SaveFragmentCompositionModal'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = ItemActions;

    var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

    var _dropDown = _interopRequireWildcard(require("@frontend-taglib-clay$clayui/drop-down"));

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _index = require("../../prop-types/index");

    var _index2 = require("../store/index");

    var _deleteItem = _interopRequireDefault(require("../thunks/deleteItem"));

    var _duplicateItem = _interopRequireDefault(require("../thunks/duplicateItem"));

    var _canBeDuplicated = _interopRequireDefault(require("../utils/canBeDuplicated"));

    var _canBeRemoved = _interopRequireDefault(require("../utils/canBeRemoved"));

    var _canBeSaved = _interopRequireDefault(require("../utils/canBeSaved"));

    var _Controls = require("./Controls");

    var _SaveFragmentCompositionModal = _interopRequireDefault(require("./SaveFragmentCompositionModal"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    function ItemActions(_ref) {
      var item = _ref.item;

      var _useState = (0, _react.useState)(false),
          _useState2 = _slicedToArray(_useState, 2),
          active = _useState2[0],
          setActive = _useState2[1];

      var dispatch = (0, _index2.useDispatch)();
      var selectItem = (0, _Controls.useSelectItem)();
      var state = (0, _index2.useSelector)(function (state) {
        return state;
      });
      var fragmentEntryLinks = state.fragmentEntryLinks,
          layoutData = state.layoutData,
          segmentsExperienceId = state.segmentsExperienceId,
          widgets = state.widgets;

      var _useState3 = (0, _react.useState)(false),
          _useState4 = _slicedToArray(_useState3, 2),
          openSaveModal = _useState4[0],
          setOpenSaveModal = _useState4[1];

      var itemActions = (0, _react.useMemo)(function () {
        var actions = [];

        if ((0, _canBeDuplicated["default"])(fragmentEntryLinks, item, layoutData, widgets)) {
          actions.push({
            action: function action() {
              return dispatch((0, _duplicateItem["default"])({
                itemId: item.itemId,
                segmentsExperienceId: segmentsExperienceId,
                selectItem: selectItem
              }));
            },
            icon: 'paste',
            label: Liferay.Language.get('duplicate')
          });
        }

        if ((0, _canBeSaved["default"])(item, layoutData)) {
          actions.push({
            action: function action() {
              return setOpenSaveModal(true);
            },
            icon: 'disk',
            label: Liferay.Language.get('save-composition')
          });
        }

        if ((0, _canBeRemoved["default"])(item, layoutData)) {
          actions.push({
            action: function action() {
              return dispatch((0, _deleteItem["default"])({
                itemId: item.itemId,
                selectItem: selectItem,
                store: state
              }));
            },
            icon: 'times-circle',
            label: Liferay.Language.get('delete')
          });
        }

        return actions;
      }, [dispatch, fragmentEntryLinks, item, layoutData, segmentsExperienceId, selectItem, state, widgets]);
      return (itemActions === null || itemActions === void 0 ? void 0 : itemActions.length) ? _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement(_dropDown["default"], {
        active: active,
        alignmentPosition: _dropDown.Align.BottomRight,
        onActiveChange: setActive,
        trigger: _react["default"].createElement(_button["default"], {
          displayType: "unstyled",
          small: true,
          title: Liferay.Language.get('options')
        }, _react["default"].createElement(_icon["default"], {
          className: "page-editor__topper__icon",
          symbol: "ellipsis-v"
        }))
      }, _react["default"].createElement(_dropDown["default"].ItemList, null, itemActions.map(function (itemAction) {
        return _react["default"].createElement(_dropDown["default"].Item, {
          key: itemAction.label,
          onClick: function onClick() {
            setActive(false);
            itemAction.action();
          },
          symbolLeft: itemAction.icon
        }, _react["default"].createElement("p", {
          className: "d-inline-block m-0 ml-4"
        }, itemAction.label));
      }))), _react["default"].createElement(_SaveFragmentCompositionModal["default"], {
        onCloseModal: function onCloseModal() {
          return setOpenSaveModal(false);
        },
        open: openSaveModal
      })) : null;
    }
    //# sourceMappingURL=ItemActions.js.map
  }
});
//# sourceMappingURL=ItemActions.js.map